<?php
session_start();

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

$adminEmail = $_SESSION['admin_email'] ?? 'admin';

// Hazır logo listesi - Yerel klasörden
$premade_logos = [
    'Bitcoin' => '../images/coin-logos/bitcoin.svg',
    'Ethereum' => '../images/coin-logos/ethereum.svg',
    'Solana' => '../images/coin-logos/solana.svg',
    'Cardano' => '../images/coin-logos/cardano.svg',
    'Polkadot' => '../images/coin-logos/polkadot.svg',
    'Avalanche' => '../images/coin-logos/avalanche.svg',
    'Chainlink' => '../images/coin-logos/chainlink.svg',
    'Cosmos' => '../images/coin-logos/cosmos.svg',
    'Polygon' => '../images/coin-logos/polygon.svg',
    'Uniswap' => '../images/coin-logos/uniswap.svg',
    'XRP' => '../images/coin-logos/xrp.svg',
    'Dogecoin' => '../images/coin-logos/dogecoin.svg'
];

// Coin verilerini yükle
$crypto_prices = [];
if (file_exists('../assets/crypto_prices.json')) {
    $price_data = json_decode(file_get_contents('../assets/crypto_prices.json'), true);
    $crypto_prices = $price_data['prices'] ?? [];
}

// Yeni coin ekleme
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add_coin') {
    $symbol = strtoupper(trim($_POST['symbol'] ?? ''));
    $name = trim($_POST['name'] ?? '');
    $price = floatval($_POST['price'] ?? 0);
    $change = floatval($_POST['change'] ?? 0);
    $volume = trim($_POST['volume'] ?? '');
    
    if ($symbol && $name && $price > 0) {
        // Görsel yükleme
        $image_path = '';
        
        // Önce hazır logo seçilmiş mi kontrol et
        if (isset($_POST['selected_logo']) && !empty($_POST['selected_logo'])) {
            $image_path = $_POST['selected_logo'];
        }
        // Yoksa dosya yükleme
        elseif (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
            $upload_dir = '../assets/uploads/coins/';
            $file_extension = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
            $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'svg'];
            
            if (in_array($file_extension, $allowed_extensions)) {
                $filename = $symbol . '_' . time() . '.' . $file_extension;
                $upload_path = $upload_dir . $filename;
                
                if (move_uploaded_file($_FILES['image']['tmp_name'], $upload_path)) {
                    $image_path = 'assets/uploads/coins/' . $filename;
                }
            }
        }
        
        // JSON dosyasına yeni coin ekle
        $crypto_prices[$symbol] = [
            'raw_price' => $price,
            'raw_change' => $change,
            'price' => '$' . number_format($price, 2),
            'change' => ($change >= 0 ? '+' : '') . number_format($change, 2) . '%',
            'volume' => $volume,
            'name' => $name,
            'image' => $image_path
        ];
        
        // JSON dosyasını güncelle
        $json_data = ['prices' => $crypto_prices];
        file_put_contents('../assets/crypto_prices.json', json_encode($json_data, JSON_PRETTY_PRINT));
        
        $success_message = "Coin başarıyla eklendi: $symbol";
    } else {
        $error_message = "Lütfen tüm alanları doldurun!";
    }
}

// Coin silme
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'delete_coin') {
    $symbol = $_POST['symbol'] ?? '';
    
    if ($symbol && isset($crypto_prices[$symbol])) {
        // Görsel dosyasını sil
        $existing_image = $crypto_prices[$symbol]['image'] ?? '';
        if ($existing_image && file_exists('../' . $existing_image)) {
            $old_file_path = '../' . $existing_image;
            if (is_writable($old_file_path)) {
                // Güvenli silme
                $max_attempts = 3;
                $attempt = 0;
                while ($attempt < $max_attempts) {
                    if (@unlink($old_file_path)) {
                        break; // Başarılı
                    }
                    $attempt++;
                    usleep(100000); // 0.1 saniye bekle
                }
            }
        }
        
        unset($crypto_prices[$symbol]);
        
        // JSON dosyasını güncelle
        $json_data = ['prices' => $crypto_prices];
        file_put_contents('../assets/crypto_prices.json', json_encode($json_data, JSON_PRETTY_PRINT));
        
        $success_message = "Coin başarıyla silindi: $symbol";
    }
}

// Coin düzenleme
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'edit_coin') {
    $symbol = $_POST['symbol'] ?? '';
    $name = trim($_POST['name'] ?? '');
    $price = floatval($_POST['price'] ?? 0);
    $change = floatval($_POST['change'] ?? 0);
    $volume = trim($_POST['volume'] ?? '');
    
    if ($symbol && isset($crypto_prices[$symbol]) && $name && $price > 0) {
        // Mevcut görseli koru
        $existing_image = $crypto_prices[$symbol]['image'] ?? '';
        
        // Yeni görsel yükleme
        if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
            $upload_dir = '../assets/uploads/coins/';
            $file_extension = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
            $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'svg'];
            
            if (in_array($file_extension, $allowed_extensions)) {
                // Eski görseli sil (güvenli silme)
                if ($existing_image && file_exists('../' . $existing_image)) {
                    // Dosya silme işlemini güvenli hale getir
                    $old_file_path = '../' . $existing_image;
                    if (is_writable($old_file_path)) {
                        // Birkaç kez deneme yap
                        $max_attempts = 3;
                        $attempt = 0;
                        while ($attempt < $max_attempts) {
                            if (@unlink($old_file_path)) {
                                break; // Başarılı
                            }
                            $attempt++;
                            usleep(100000); // 0.1 saniye bekle
                        }
                    }
                }
                
                $filename = $symbol . '_' . time() . '.' . $file_extension;
                $upload_path = $upload_dir . $filename;
                
                if (move_uploaded_file($_FILES['image']['tmp_name'], $upload_path)) {
                    $existing_image = 'assets/uploads/coins/' . $filename;
                }
            }
        }
        
        $crypto_prices[$symbol] = [
            'raw_price' => $price,
            'raw_change' => $change,
            'price' => '$' . number_format($price, 2),
            'change' => ($change >= 0 ? '+' : '') . number_format($change, 2) . '%',
            'volume' => $volume,
            'name' => $name,
            'image' => $existing_image
        ];
        
        // JSON dosyasını güncelle
        $json_data = ['prices' => $crypto_prices];
        file_put_contents('../assets/crypto_prices.json', json_encode($json_data, JSON_PRETTY_PRINT));
        
        $success_message = "Coin başarıyla güncellendi: $symbol";
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Coin Yönetimi - Admin Panel</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body>
<div class="flex min-h-screen bg-muted/20">
    <!-- Sidebar -->
    <div class="h-full fixed max-lg:w-[calc(100vw-35px)] top-0 left-0 z-50 flex-col bg-gradient-to-b from-background to-muted/20 border-r hidden lg:block w-64">
        <div class="h-14 flex items-center px-4 border-b">
            <a class="flex items-center gap-2" href="/">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-gauge h-6 w-6 text-primary"><path d="m12 14 4-4"></path><path d="M3.34 19a10 10 0 1 1 17.32 0"></path></svg>
                <span class="font-semibold text-lg">Coin Platform</span>
            </a>
        </div>
        <div dir="ltr" class="max-h-[calc(100vh-100px)] overflow-auto">
            <div class="flex-1 overflow-auto py-4">
                <div class="py-2">
                    <div class="px-4 mb-2"><h2 class="text-xs font-semibold text-muted-foreground uppercase tracking-wider">Platform</h2></div>
                    <div class="space-y-1 px-2">
                        <a class="block" href="index.php">
                            <div class="group flex items-center py-2.5 px-3 text-sm font-medium rounded-lg transition-all duration-200 text-muted-foreground hover:bg-muted/50 hover:text-foreground">
                                <span class="mr-3 flex-shrink-0 text-muted-foreground group-hover:text-foreground">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-layout-dashboard h-4 w-4"><rect width="7" height="9" x="3" y="3" rx="1"></rect><rect width="7" height="5" x="14" y="3" rx="1"></rect><rect width="7" height="9" x="14" y="12" rx="1"></rect><rect width="7" height="5" x="3" y="16" rx="1"></rect></svg>
                                </span>
                                <span class="truncate">Genel Bakış</span>
                            </div>
                        </a>
                        <a class="block" href="coins.php">
                            <div class="group flex items-center py-2.5 px-3 text-sm font-medium rounded-lg transition-all duration-200 bg-primary/10 text-primary shadow-sm">
                                <span class="mr-3 flex-shrink-0 text-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-coins h-4 w-4"><circle cx="8" cy="8" r="6"></circle><path d="M18.09 10.37A6 6 0 1 1 10.34 18"></path><path d="M7 6h1v4"></path><path d="m16.71 13.88.7.71-2.82 2.82"></path></svg>
                                </span>
                                <span class="truncate">Coinler</span>
                                <span class="ml-auto h-1.5 w-1.5 rounded-full bg-primary"></span>
                            </div>
                        </a>
                    </div>
                </div>
                <!-- Diğer menü öğeleri... -->
            </div>
        </div>
        <div class="p-1 border-t">
            <a href="logout.php" class="flex w-full items-center px-3 py-2.5 text-sm font-medium rounded-lg text-red-600 hover:bg-red-50/50 transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-log-out mr-3 h-4 w-4"><path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"></path><polyline points="16 17 21 12 16 7"></polyline><line x1="21" x2="9" y1="12" y2="12"></line></svg>
                <span>Çıkış Yap</span>
            </a>
        </div>
    </div>

    <!-- Main -->
    <div class="flex-1 flex flex-col">
        <header class="sticky top-0 z-40 w-full border-b bg-background/95 backdrop-blur supports-[backdrop-filter]:bg-background/60">
            <div class="flex h-14 items-center">
                <div class="flex items-center gap-2 lg:hidden pl-6">
                    <button class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium hover:bg-accent hover:text-accent-foreground h-9 w-9 md:hidden" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-menu h-5 w-5"><line x1="4" x2="20" y1="12" y2="12"></line><line x1="4" x2="20" y1="6" y2="6"></line><line x1="4" x2="20" y1="18" y2="18"></line></svg>
                        <span class="sr-only">Toggle Menu</span>
                    </button>
                </div>
                <div class="flex flex-1 items-center justify-between space-x-2 md:justify-end">
                    <div class="w-full flex-1 md:w-auto md:flex-none"></div>
                    <nav class="flex items-center gap-2 pr-6">
                        <button class="inline-flex items-center justify-center gap-2 whitespace-nowrap text-sm font-medium hover:bg-accent hover:text-accent-foreground px-4 py-2 relative h-9 w-9 rounded-full" type="button">
                            <span class="relative flex shrink-0 overflow-hidden rounded-full h-9 w-9 border-2 border-primary/10">
                                <span class="flex h-full w-full items-center justify-center rounded-full bg-primary/5 text-primary">A</span>
                            </span>
                            <span class="sr-only">Kullanıcı menüsü</span>
                        </button>
                    </nav>
                </div>
            </div>
        </header>
        
        <main class="flex-1 ml-[255px] max-lg:ml-0">
            <div class="py-6">
                <div class="mx-auto max-w-7xl">
                    <div class="p-6 md:p-8">
                        <div class="flex-1 space-y-4">
                            <div class="flex items-center justify-between space-y-2">
                                <h2 class="text-3xl font-bold tracking-tight">Coin Yönetimi</h2>
                                <button onclick="openAddModal()" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium bg-primary text-primary-foreground shadow hover:bg-primary/90 h-9 px-4 py-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-plus h-4 w-4"><path d="M5 12h14"></path><path d="M12 5v14"></path></svg>
                                    Yeni Coin Ekle
                                </button>
                            </div>

                            <?php if (isset($success_message)): ?>
                                <div class="rounded-md bg-green-50 p-4">
                                    <div class="text-sm text-green-700"><?php echo htmlspecialchars($success_message); ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if (isset($error_message)): ?>
                                <div class="rounded-md bg-red-50 p-4">
                                    <div class="text-sm text-red-700"><?php echo htmlspecialchars($error_message); ?></div>
                                </div>
                            <?php endif; ?>

                            <div class="rounded-lg border bg-card text-card-foreground shadow-sm">
                                <div class="flex flex-col space-y-1.5 p-6">
                                    <h3 class="text-2xl font-semibold leading-none tracking-tight">Mevcut Coinler</h3>
                                </div>
                                <div class="p-6 pt-0">
                                    <div class="overflow-x-auto">
                                        <table class="w-full">
                                            <thead>
                                                <tr class="border-b">
                                                    <th class="text-left py-3 px-4 font-medium">Görsel</th>
                                                    <th class="text-left py-3 px-4 font-medium">Sembol</th>
                                                    <th class="text-left py-3 px-4 font-medium">İsim</th>
                                                    <th class="text-left py-3 px-4 font-medium">Fiyat</th>
                                                    <th class="text-left py-3 px-4 font-medium">Değişim</th>
                                                    <th class="text-left py-3 px-4 font-medium">Hacim</th>
                                                    <th class="text-left py-3 px-4 font-medium">İşlemler</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($crypto_prices as $symbol => $data): ?>
                                                <tr class="border-b">
                                                    <td class="py-3 px-4">
                                                        <?php if (!empty($data['image'])): ?>
                                                            <img src="../<?php echo htmlspecialchars($data['image']); ?>" alt="<?php echo htmlspecialchars($symbol); ?>" class="w-8 h-8 rounded-full object-cover">
                                                        <?php else: ?>
                                                            <div class="w-8 h-8 rounded-full bg-gray-200 flex items-center justify-center text-xs font-medium">
                                                                <?php echo substr($symbol, 0, 2); ?>
                                                            </div>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td class="py-3 px-4 font-medium"><?php echo htmlspecialchars($symbol); ?></td>
                                                    <td class="py-3 px-4"><?php echo htmlspecialchars($data['name'] ?? $symbol); ?></td>
                                                    <td class="py-3 px-4"><?php echo htmlspecialchars($data['price'] ?? '$0.00'); ?></td>
                                                    <td class="py-3 px-4">
                                                        <span class="<?php echo (floatval($data['raw_change'] ?? 0) >= 0) ? 'text-green-600' : 'text-red-600'; ?>">
                                                            <?php echo htmlspecialchars($data['change'] ?? '0%'); ?>
                                                        </span>
                                                    </td>
                                                    <td class="py-3 px-4"><?php echo htmlspecialchars($data['volume'] ?? '-'); ?></td>
                                                    <td class="py-3 px-4">
                                                        <div class="flex gap-2">
                                                            <button onclick="openEditModal('<?php echo $symbol; ?>', '<?php echo htmlspecialchars($data['name'] ?? $symbol); ?>', <?php echo floatval($data['raw_price'] ?? 0); ?>, <?php echo floatval($data['raw_change'] ?? 0); ?>, '<?php echo htmlspecialchars($data['volume'] ?? ''); ?>', '<?php echo htmlspecialchars($data['image'] ?? ''); ?>')" class="text-blue-600 hover:text-blue-800 text-sm">Düzenle</button>
                                                            <button onclick="deleteCoin('<?php echo $symbol; ?>')" class="text-red-600 hover:text-red-800 text-sm">Sil</button>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<!-- Add Coin Modal -->
<div id="addModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-lg p-6 w-full max-w-md">
            <h3 class="text-lg font-semibold mb-4">Yeni Coin Ekle</h3>
            <form method="POST" enctype="multipart/form-data">
                <input type="hidden" name="action" value="add_coin">
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium mb-1">Sembol</label>
                        <input type="text" name="symbol" required class="w-full border rounded px-3 py-2" placeholder="BTC">
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-1">İsim</label>
                        <input type="text" name="name" required class="w-full border rounded px-3 py-2" placeholder="Bitcoin">
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-1">Logo Seç</label>
                        <div class="relative">
                            <button type="button" onclick="openLogoSelector()" class="w-full border rounded px-3 py-2 text-left flex items-center justify-between">
                                <span id="selectedLogoText">Hazır logolardan seçin</span>
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </button>
                            <input type="hidden" name="selected_logo" id="selectedLogo">
                        </div>
                        <div class="mt-2">
                            <label class="block text-sm font-medium mb-1">Veya özel görsel yükle</label>
                            <input type="file" name="image" accept="image/*,.svg" class="w-full border rounded px-3 py-2">
                            <p class="text-xs text-gray-500 mt-1">JPG, PNG, GIF, WebP, SVG formatları desteklenir</p>
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-1">Fiyat</label>
                        <input type="number" name="price" step="0.01" required class="w-full border rounded px-3 py-2" placeholder="50000.00">
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-1">Değişim (%)</label>
                        <input type="number" name="change" step="0.01" class="w-full border rounded px-3 py-2" placeholder="2.5">
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-1">Hacim</label>
                        <input type="text" name="volume" class="w-full border rounded px-3 py-2" placeholder="1.2B">
                    </div>
                </div>
                <div class="flex gap-2 mt-6">
                    <button type="submit" class="flex-1 bg-blue-600 text-white py-2 px-4 rounded hover:bg-blue-700">Ekle</button>
                    <button type="button" onclick="closeAddModal()" class="flex-1 bg-gray-300 text-gray-700 py-2 px-4 rounded hover:bg-gray-400">İptal</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Coin Modal -->
<div id="editModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-lg p-6 w-full max-w-md">
            <h3 class="text-lg font-semibold mb-4">Coin Düzenle</h3>
            <form method="POST" enctype="multipart/form-data">
                <input type="hidden" name="action" value="edit_coin">
                <input type="hidden" name="symbol" id="edit_symbol">
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium mb-1">Sembol</label>
                        <input type="text" id="edit_symbol_display" readonly class="w-full border rounded px-3 py-2 bg-gray-100">
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-1">İsim</label>
                        <input type="text" name="name" id="edit_name" required class="w-full border rounded px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-1">Mevcut Görsel</label>
                        <div id="edit_current_image" class="mb-2"></div>
                        <label class="block text-sm font-medium mb-1">Yeni Görsel (Değiştirmek için)</label>
                        <input type="file" name="image" accept="image/*,.svg" class="w-full border rounded px-3 py-2">
                        <p class="text-xs text-gray-500 mt-1">JPG, PNG, GIF, WebP, SVG formatları desteklenir</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-1">Fiyat</label>
                        <input type="number" name="price" id="edit_price" step="0.01" required class="w-full border rounded px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-1">Değişim (%)</label>
                        <input type="number" name="change" id="edit_change" step="0.01" class="w-full border rounded px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-1">Hacim</label>
                        <input type="text" name="volume" id="edit_volume" class="w-full border rounded px-3 py-2">
                    </div>
                </div>
                <div class="flex gap-2 mt-6">
                    <button type="submit" class="flex-1 bg-blue-600 text-white py-2 px-4 rounded hover:bg-blue-700">Güncelle</button>
                    <button type="button" onclick="closeEditModal()" class="flex-1 bg-gray-300 text-gray-700 py-2 px-4 rounded hover:bg-gray-400">İptal</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Logo Selector Modal -->
<div id="logoSelectorModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-lg w-full max-w-2xl max-h-[80vh] overflow-hidden">
            <div class="p-6 border-b">
                <div class="flex items-center justify-between">
                    <h3 class="text-lg font-semibold">Logo Seçin</h3>
                    <button onclick="closeLogoSelector()" class="text-gray-400 hover:text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>
                <div class="mt-4">
                    <input type="text" id="logoSearch" placeholder="Logo ara..." class="w-full border rounded px-3 py-2" onkeyup="filterLogos()">
                </div>
            </div>
            <div class="p-6 max-h-96 overflow-y-auto">
                <div id="logoGrid" class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
                    <?php foreach ($premade_logos as $name => $path): ?>
                        <div class="logo-option border rounded-lg p-3 cursor-pointer hover:bg-gray-50 transition-colors" 
                             data-name="<?php echo htmlspecialchars($name); ?>" 
                             data-path="<?php echo htmlspecialchars($path); ?>"
                             onclick="selectLogo('<?php echo htmlspecialchars($name); ?>', '<?php echo htmlspecialchars($path); ?>')">
                            <div class="flex flex-col items-center space-y-2">
                                <div class="w-12 h-12 rounded-full overflow-hidden bg-gray-100 flex items-center justify-center">
                                    <img src="<?php echo htmlspecialchars($path); ?>" alt="<?php echo htmlspecialchars($name); ?>" 
                                         class="w-8 h-8 object-contain" 
                                         onerror="this.src='data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMzIiIGhlaWdodD0iMzIiIHZpZXdCb3g9IjAgMCAzMiAzMiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMTYiIGN5PSIxNiIgcj0iMTQiIGZpbGw9IiNmM2Y0ZjYiLz4KPHN2ZyB4PSI4IiB5PSI4IiB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTggMkM0LjY5IDEuOTkgMi4wMSA0LjY3IDIgOFM0LjY3IDEzLjk5IDggMTRTMTMuOTkgMTEuMzMgMTQgOFMxMS4zMyAyLjAxIDggMloiIGZpbGw9IiM5Y2EzYWYiLz4KPC9zdmc+Cjwvc3ZnPgo='">
                                </div>
                                <span class="text-xs text-center text-gray-700"><?php echo htmlspecialchars($name); ?></span>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function openAddModal() {
    document.getElementById('addModal').classList.remove('hidden');
}

function closeAddModal() {
    document.getElementById('addModal').classList.add('hidden');
}

function openEditModal(symbol, name, price, change, volume, image) {
    document.getElementById('edit_symbol').value = symbol;
    document.getElementById('edit_symbol_display').value = symbol;
    document.getElementById('edit_name').value = name;
    document.getElementById('edit_price').value = price;
    document.getElementById('edit_change').value = change;
    document.getElementById('edit_volume').value = volume;
    
    // Mevcut görseli göster
    const currentImageDiv = document.getElementById('edit_current_image');
    if (image && image.trim() !== '') {
        currentImageDiv.innerHTML = `<img src="../${image}" alt="${symbol}" class="w-16 h-16 rounded-full object-cover">`;
    } else {
        currentImageDiv.innerHTML = `<div class="w-16 h-16 rounded-full bg-gray-200 flex items-center justify-center text-sm font-medium">${symbol.substring(0, 2)}</div>`;
    }
    
    document.getElementById('editModal').classList.remove('hidden');
}

function closeEditModal() {
    document.getElementById('editModal').classList.add('hidden');
}

function deleteCoin(symbol) {
    if (confirm('Bu coin\'i silmek istediğinizden emin misiniz?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.innerHTML = `
            <input type="hidden" name="action" value="delete_coin">
            <input type="hidden" name="symbol" value="${symbol}">
        `;
        document.body.appendChild(form);
        form.submit();
    }
}

// Logo selector functions
function openLogoSelector() {
    document.getElementById('logoSelectorModal').classList.remove('hidden');
}

function closeLogoSelector() {
    document.getElementById('logoSelectorModal').classList.add('hidden');
}

function selectLogo(name, path) {
    document.getElementById('selectedLogoText').textContent = name;
    document.getElementById('selectedLogo').value = path;
    closeLogoSelector();
}

function filterLogos() {
    const searchTerm = document.getElementById('logoSearch').value.toLowerCase();
    const logoOptions = document.querySelectorAll('.logo-option');
    
    logoOptions.forEach(option => {
        const name = option.getAttribute('data-name').toLowerCase();
        if (name.includes(searchTerm)) {
            option.style.display = 'block';
        } else {
            option.style.display = 'none';
        }
    });
}
</script>
</body>
</html>
