<?php
session_start();

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

$adminEmail = $_SESSION['admin_email'] ?? 'admin';

// Dosya kaydetme işlemi
$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    $action = $_POST['action'];
    
    if ($action === 'save_header') {
        $content = $_POST['content'] ?? '';
        $file_path = '../components/header.php';
        
        // Yedek oluştur
        if (file_exists($file_path)) {
            $backup_path = '../components/header_backup_' . date('Y-m-d_H-i-s') . '.php';
            @copy($file_path, $backup_path);
        }
        
        if (file_put_contents($file_path, $content)) {
            $success_message = 'Header başarıyla güncellendi!';
        } else {
            $error_message = 'Header güncellenirken bir hata oluştu.';
        }
    } elseif ($action === 'save_footer') {
        $content = $_POST['content'] ?? '';
        $file_path = '../components/footer.php';
        
        // Yedek oluştur
        if (file_exists($file_path)) {
            $backup_path = '../components/footer_backup_' . date('Y-m-d_H-i-s') . '.php';
            @copy($file_path, $backup_path);
        }
        
        if (file_put_contents($file_path, $content)) {
            $success_message = 'Footer başarıyla güncellendi!';
        } else {
            $error_message = 'Footer güncellenirken bir hata oluştu.';
        }
    }
}

// Dosya içeriklerini oku
$header_content = file_exists('../components/header.php') ? file_get_contents('../components/header.php') : '';
$footer_content = file_exists('../components/footer.php') ? file_get_contents('../components/footer.php') : '';

require_once '../config/database.php';
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bileşen Yönetimi - Admin Panel</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body>
<div class="flex min-h-screen bg-muted/20">
    <!-- Sidebar -->
    <div class="h-full fixed max-lg:w-[calc(100vw-35px)] top-0 left-0 z-50 flex-col bg-gradient-to-b from-background to-muted/20 border-r hidden lg:block w-64">
        <div class="h-14 flex items-center px-4 border-b">
            <a class="flex items-center gap-2" href="index.php">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-gauge h-6 w-6 text-primary"><path d="m12 14 4-4"></path><path d="M3.34 19a10 10 0 1 1 17.32 0"></path></svg>
                <span class="font-semibold text-lg">Coin Platform</span>
            </a>
        </div>
        <div dir="ltr" class="max-h-[calc(100vh-100px)] overflow-auto">
            <div class="flex-1 overflow-auto py-4">
                <div class="py-2">
                    <div class="px-4 mb-2"><h2 class="text-xs font-semibold text-muted-foreground uppercase tracking-wider">Platform</h2></div>
                    <div class="space-y-1 px-2">
                        <a class="block" href="index.php">
                            <div class="group flex items-center py-2.5 px-3 text-sm font-medium rounded-lg transition-all duration-200 text-muted-foreground hover:bg-muted/50 hover:text-foreground">
                                <span class="mr-3 flex-shrink-0 text-muted-foreground group-hover:text-foreground">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-layout-dashboard h-4 w-4"><rect width="7" height="9" x="3" y="3" rx="1"></rect><rect width="7" height="5" x="14" y="3" rx="1"></rect><rect width="7" height="9" x="14" y="12" rx="1"></rect><rect width="7" height="5" x="3" y="16" rx="1"></rect></svg>
                                </span>
                                <span class="truncate">Genel Bakış</span>
                            </div>
                        </a>
                        <a class="block" href="coins.php">
                            <div class="group flex items-center py-2.5 px-3 text-sm font-medium rounded-lg transition-all duration-200 text-muted-foreground hover:bg-muted/50 hover:text-foreground">
                                <span class="mr-3 flex-shrink-0 text-muted-foreground group-hover:text-foreground">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-coins h-4 w-4"><circle cx="8" cy="8" r="6"></circle><path d="M18.09 10.37A6 6 0 1 1 10.34 18"></path><path d="M7 6h1v4"></path><path d="m16.71 13.88.7.71-2.82 2.82"></path></svg>
                                </span>
                                <span class="truncate">Coinler</span>
                            </div>
                        </a>
                    </div>
                </div>

                <div class="py-2 mt-2">
                    <div class="px-4 mb-2"><h2 class="text-xs font-semibold text-muted-foreground uppercase tracking-wider">Kullanıcılar ve İşlemler</h2></div>
                    <div class="space-y-1 px-2">
                        <a class="block" href="users.php">
                            <div class="group flex items-center py-2.5 px-3 text-sm font-medium rounded-lg transition-all duration-200 text-muted-foreground hover:bg-muted/50 hover:text-foreground">
                                <span class="mr-3 flex-shrink-0 text-muted-foreground group-hover:text-foreground">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-users h-4 w-4"><path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path><circle cx="9" cy="7" r="4"></circle><path d="M22 21v-2a4 4 0 0 0-3-3.87"></path><path d="M16 3.13a4 4 0 0 1 0 7.75"></path></svg>
                                </span>
                                <span class="truncate">Kullanıcılar</span>
                            </div>
                        </a>
                        <a class="block" href="deposits.php">
                            <div class="group flex items-center py-2.5 px-3 text-sm font-medium rounded-lg transition-all duration-200 text-muted-foreground hover:bg-muted/50 hover:text-foreground">
                                <span class="mr-3 flex-shrink-0 text-muted-foreground group-hover:text-foreground">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-credit-card h-4 w-4"><rect width="20" height="14" x="2" y="5" rx="2"></rect><line x1="2" x2="22" y1="10" y2="10"></line></svg>
                                </span>
                                <span class="truncate">Para Yatırma</span>
                            </div>
                        </a>
                        <a class="block" href="withdrawals.php">
                            <div class="group flex items-center py-2.5 px-3 text-sm font-medium rounded-lg transition-all duration-200 text-muted-foreground hover:bg-muted/50 hover:text-foreground">
                                <span class="mr-3 flex-shrink-0 text-muted-foreground group-hover:text-foreground">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-banknote h-4 w-4"><rect width="20" height="12" x="2" y="6" rx="2"></rect><circle cx="12" cy="12" r="2"></circle><path d="M6 12h.01M18 12h.01"></path></svg>
                                </span>
                                <span class="truncate">Çekim Talepleri</span>
                            </div>
                        </a>
                    </div>
                </div>

                <div class="py-2 mt-2">
                    <div class="px-4 mb-2"><h2 class="text-xs font-semibold text-muted-foreground uppercase tracking-wider">İçerik Yönetimi</h2></div>
                    <div class="space-y-1 px-2">
                        <a class="block" href="bank_accounts.php">
                            <div class="group flex items-center py-2.5 px-3 text-sm font-medium rounded-lg transition-all duration-200 text-muted-foreground hover:bg-muted/50 hover:text-foreground">
                                <span class="mr-3 flex-shrink-0 text-muted-foreground group-hover:text-foreground">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-building2 h-4 w-4"><path d="M6 22V4a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v18Z"></path><path d="M6 12H4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h2"></path><path d="M18 9h2a2 2 0 0 1 2 2v9a2 2 0 0 1-2 2h-2"></path><path d="M10 6h4"></path><path d="M10 10h4"></path><path d="M10 14h4"></path><path d="M10 18h4"></path></svg>
                                </span>
                                <span class="truncate">Banka Hesapları</span>
                            </div>
                        </a>
                        <a class="block" href="crypto_addresses.php">
                            <div class="group flex items-center py-2.5 px-3 text-sm font-medium rounded-lg transition-all duration-200 text-muted-foreground hover:bg-muted/50 hover:text-foreground">
                                <span class="mr-3 flex-shrink-0 text-muted-foreground group-hover:text-foreground">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-coins h-4 w-4"><circle cx="8" cy="8" r="6"></circle><path d="M18.09 10.37A6 6 0 1 1 10.34 18"></path><path d="M7 6h1v4"></path><path d="m16.71 13.88.7.71-2.82 2.82"></path></svg>
                                </span>
                                <span class="truncate">Kripto Adresleri</span>
                            </div>
                        </a>
                        <a class="block" href="components.php">
                            <div class="group flex items-center py-2.5 px-3 text-sm font-medium rounded-lg transition-all duration-200 bg-primary/10 text-primary shadow-sm">
                                <span class="mr-3 flex-shrink-0 text-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-layout h-4 w-4"><rect width="18" height="18" x="3" y="3" rx="2" ry="2"></rect><line x1="3" x2="21" y1="9" y2="9"></line><line x1="9" x2="9" y1="21" y2="9"></line></svg>
                                </span>
                                <span class="truncate">Header & Footer</span>
                                <span class="ml-auto h-1.5 w-1.5 rounded-full bg-primary"></span>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="p-1 border-t">
            <a href="logout.php" class="flex w-full items-center px-3 py-2.5 text-sm font-medium rounded-lg text-red-600 hover:bg-red-50/50 transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-log-out mr-3 h-4 w-4"><path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"></path><polyline points="16 17 21 12 16 7"></polyline><line x1="21" x2="9" y1="12" y2="12"></line></svg>
                <span>Çıkış Yap</span>
            </a>
        </div>
    </div>

    <!-- Main Content -->
    <div class="flex-1 lg:ml-64">
        <header class="sticky top-0 z-40 w-full border-b bg-background/95 backdrop-blur supports-[backdrop-filter]:bg-background/60">
            <div class="flex h-14 items-center">
                <div class="flex items-center gap-2 lg:hidden pl-6">
                    <button class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium hover:bg-accent hover:text-accent-foreground h-9 w-9 md:hidden" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-menu h-5 w-5"><line x1="4" x2="20" y1="12" y2="12"></line><line x1="4" x2="20" y1="6" y2="6"></line><line x1="4" x2="20" y1="18" y2="18"></line></svg>
                        <span class="sr-only">Toggle Menu</span>
                    </button>
                </div>
                <div class="flex flex-1 items-center justify-between space-x-2 md:justify-end">
                    <div class="w-full flex-1 md:w-auto md:flex-none"></div>
                    <nav class="flex items-center gap-2 pr-6">
                        <span class="text-sm text-gray-600"><?php echo htmlspecialchars($adminEmail); ?></span>
                    </nav>
                </div>
            </div>
        </header>
        
        <main class="p-6">
            <!-- Header -->
            <div class="mb-6">
                <h1 class="text-3xl font-bold text-gray-800">Bileşen Yönetimi</h1>
                <p class="text-gray-600 mt-2">Header ve Footer dosyalarını düzenleyin</p>
            </div>
            
            <!-- Messages -->
            <?php if ($success_message): ?>
                <div class="mb-4 px-4 py-3 bg-green-100 border border-green-400 text-green-700 rounded-lg">
                    <?php echo htmlspecialchars($success_message); ?>
                </div>
            <?php endif; ?>
            
            <?php if ($error_message): ?>
                <div class="mb-4 px-4 py-3 bg-red-100 border border-red-400 text-red-700 rounded-lg">
                    <?php echo htmlspecialchars($error_message); ?>
                </div>
            <?php endif; ?>
            
            <!-- Tabs -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 mb-6">
                <div class="border-b border-gray-200">
                    <div class="flex space-x-4 px-6">
                        <button onclick="showTab('header')" id="header-tab" class="px-4 py-3 border-b-2 border-blue-600 text-blue-600 font-medium">
                            Header
                        </button>
                        <button onclick="showTab('footer')" id="footer-tab" class="px-4 py-3 border-b-2 border-transparent text-gray-600 hover:text-gray-900 font-medium">
                            Footer
                        </button>
                    </div>
                </div>
                
                <!-- Header Tab -->
                <div id="header-tab-content" class="p-6">
                    <form method="POST" action="">
                        <input type="hidden" name="action" value="save_header">
                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-700 mb-2">Header İçeriği (PHP/HTML)</label>
                            <textarea 
                                name="content" 
                                id="header-editor"
                                rows="30"
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 font-mono text-sm"
                                required><?php echo htmlspecialchars($header_content); ?></textarea>
                            <p class="text-xs text-gray-500 mt-2">⚠️ Dikkat: PHP kodlarını düzenlerken dikkatli olun!</p>
                        </div>
                        <div class="flex gap-2">
                            <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                                Kaydet
                            </button>
                            <button type="button" onclick="previewFile('header')" class="px-6 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700 transition-colors">
                                Önizle
                            </button>
                        </div>
                    </form>
                </div>
                
                <!-- Footer Tab -->
                <div id="footer-tab-content" class="p-6 hidden">
                    <form method="POST" action="">
                        <input type="hidden" name="action" value="save_footer">
                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-700 mb-2">Footer İçeriği (PHP/HTML)</label>
                            <textarea 
                                name="content" 
                                id="footer-editor"
                                rows="20"
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 font-mono text-sm"
                                required><?php echo htmlspecialchars($footer_content); ?></textarea>
                            <p class="text-xs text-gray-500 mt-2">⚠️ Dikkat: PHP kodlarını düzenlerken dikkatli olun!</p>
                        </div>
                        <div class="flex gap-2">
                            <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                                Kaydet
                            </button>
                            <button type="button" onclick="previewFile('footer')" class="px-6 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700 transition-colors">
                                Önizle
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- Info Box -->
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                <div class="flex items-start">
                    <svg class="w-5 h-5 text-blue-600 mt-0.5 mr-3" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                    </svg>
                    <div>
                        <h3 class="font-semibold text-blue-900 mb-1">Bilgi</h3>
                        <ul class="text-sm text-blue-800 space-y-1">
                            <li>• Dosyalar kaydedilmeden önce otomatik olarak yedeklenir.</li>
                            <li>• Yedek dosyalar <code class="bg-blue-100 px-1 rounded">components/</code> klasöründe saklanır.</li>
                            <li>• PHP kodlarını düzenlerken hata yapmamaya dikkat edin.</li>
                            <li>• Değişiklikler anında canlıya geçer.</li>
                        </ul>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<script>
function showTab(tabName) {
    // Hide all tabs
    document.getElementById('header-tab-content').classList.add('hidden');
    document.getElementById('footer-tab-content').classList.add('hidden');
    
    // Remove active class from all tabs
    document.getElementById('header-tab').classList.remove('border-blue-600', 'text-blue-600');
    document.getElementById('header-tab').classList.add('border-transparent', 'text-gray-600');
    document.getElementById('footer-tab').classList.remove('border-blue-600', 'text-blue-600');
    document.getElementById('footer-tab').classList.add('border-transparent', 'text-gray-600');
    
    // Show selected tab
    document.getElementById(tabName + '-tab-content').classList.remove('hidden');
    
    // Add active class to selected tab
    document.getElementById(tabName + '-tab').classList.remove('border-transparent', 'text-gray-600');
    document.getElementById(tabName + '-tab').classList.add('border-blue-600', 'text-blue-600');
}

function previewFile(type) {
    const editor = document.getElementById(type + '-editor');
    const content = editor.value;
    
    // Open preview in new window
    const preview = window.open('', '_blank');
    preview.document.write(`
        <!DOCTYPE html>
        <html>
        <head>
            <title>${type === 'header' ? 'Header' : 'Footer'} Önizleme</title>
            <script src="https://cdn.tailwindcss.com"><\/script>
        </head>
        <body>
            ${content}
        </body>
        </html>
    `);
    preview.document.close();
}

// Initialize with header tab active
document.addEventListener('DOMContentLoaded', function() {
    showTab('header');
});
</script>
</body>
</html>
