<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Giriş yapmanız gerekiyor.']);
    exit;
}

require_once __DIR__ . '/../config/database.php';

$user_id = $_SESSION['user_id'];
$coin_symbol = $_POST['coin_symbol'] ?? '';
$amount = floatval($_POST['amount'] ?? 0);
$rate = floatval($_POST['rate'] ?? 0);

if ($coin_symbol === '' || $amount <= 0 || $rate <= 0) {
    echo json_encode(['success' => false, 'message' => 'Geçerli bilgiler giriniz.']);
    exit;
}

try {
    $db = getDB();
    $db->beginTransaction();

    // Yeterli bakiye kontrolü
    $stmt = $db->prepare('SELECT available FROM wallets WHERE user_id = ? AND coin_symbol = ?');
    $stmt->execute([$user_id, $coin_symbol]);
    $wallet = $stmt->fetch();
    if (!$wallet || $wallet['available'] < $amount) {
        throw new Exception('Yetersiz bakiye!');
    }

    // Bakiye dondur
    $stmt = $db->prepare('UPDATE wallets SET available = available - ?, frozen = frozen + ? WHERE user_id = ? AND coin_symbol = ?');
    $stmt->execute([$amount, $amount, $user_id, $coin_symbol]);

    // Lending kaydı ekle
    $stmt = $db->prepare('INSERT INTO lendings (user_id, coin_symbol, amount, interest_rate, interest_earned, status) VALUES (?, ?, ?, ?, 0, "active")');
    $stmt->execute([$user_id, $coin_symbol, $amount, $rate]);

    // İşlem kaydı
    $stmt = $db->prepare('INSERT INTO transactions (user_id, type, coin_symbol, amount, price, status, created_at) VALUES (?, "lend", ?, ?, 0, "completed", NOW())');
    $stmt->execute([$user_id, $coin_symbol, -$amount]);

    $db->commit();

    echo json_encode(['success' => true, 'message' => "Başarıyla ödünç verildi: {$amount} {$coin_symbol} @ {$rate}%", 'lending_id' => $db->lastInsertId()]);
} catch (Throwable $e) {
    if ($db && $db->inTransaction()) $db->rollBack();
    echo json_encode(['success' => false, 'message' => 'Hata: ' . $e->getMessage()]);
}
