<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Giriş yapmanız gerekiyor.']);
    exit;
}

require_once '../config/database.php';

$user_id = $_SESSION['user_id'];
$coin_symbol = $_POST['coin_symbol'] ?? '';
$amount = floatval($_POST['amount'] ?? 0);
$lock_period = intval($_POST['lock_period'] ?? 30);
$apy = floatval($_POST['apy'] ?? 10);

if (empty($coin_symbol) || $amount <= 0) {
    echo json_encode(['success' => false, 'message' => 'Geçerli bilgiler giriniz.']);
    exit;
}

try {
    $db = getDB();
    $db->beginTransaction();
    
    // Kullanıcının bakiyesini kontrol et
    $stmt = $db->prepare("SELECT * FROM wallets WHERE user_id = ? AND coin_symbol = ? AND available >= ?");
    $stmt->execute([$user_id, $coin_symbol, $amount]);
    $wallet = $stmt->fetch();
    
    if (!$wallet) {
        throw new Exception('Yetersiz bakiye!');
    }
    
    // Bakiyeyi dondur (available'dan frozen'a taşı)
    $stmt = $db->prepare("UPDATE wallets SET available = available - ?, frozen = frozen + ? WHERE user_id = ? AND coin_symbol = ?");
    $stmt->execute([$amount, $amount, $user_id, $coin_symbol]);
    
    // Unlock tarihini hesapla
    $unlock_date = date('Y-m-d H:i:s', strtotime("+{$lock_period} days"));
    
    // Stake kaydı oluştur
    $stmt = $db->prepare("INSERT INTO stakes (user_id, coin_symbol, amount, apy, lock_period, rewards, status, unlock_date, created_at) VALUES (?, ?, ?, ?, ?, 0, 'active', ?, NOW())");
    $stmt->execute([$user_id, $coin_symbol, $amount, $apy, $lock_period, $unlock_date]);
    
    // İşlem kaydı ekle
    $stmt = $db->prepare("INSERT INTO transactions (user_id, type, coin_symbol, amount, price, status, created_at) VALUES (?, 'stake', ?, ?, 0, 'completed', NOW())");
    $stmt->execute([$user_id, $coin_symbol, -$amount]);
    
    $db->commit();
    
    echo json_encode([
        'success' => true, 
        'message' => "{$amount} {$coin_symbol} başarıyla {$lock_period} gün için stake edildi!",
        'data' => [
            'stake_id' => $db->lastInsertId(),
            'amount' => $amount,
            'coin_symbol' => $coin_symbol,
            'apy' => $apy,
            'lock_period' => $lock_period,
            'unlock_date' => $unlock_date
        ]
    ]);
    
} catch (Exception $e) {
    $db->rollBack();
    echo json_encode(['success' => false, 'message' => 'Hata: ' . $e->getMessage()]);
}
?>
