<?php
session_start();
header('Content-Type: application/json');
if (!isset($_SESSION['user_id'])) { echo json_encode(['success'=>false,'message'=>'Giriş yapın.']); exit; }
require_once __DIR__ . '/../config/database.php';

$user_id = $_SESSION['user_id'];
$pool_name = $_POST['pool_name'] ?? '';
$token_pair = $_POST['token_pair'] ?? '';
$coin1 = $_POST['coin1'] ?? '';
$coin2 = $_POST['coin2'] ?? '';
$amount1 = floatval($_POST['amount1'] ?? 0);
$amount2 = floatval($_POST['amount2'] ?? 0);
$apy = floatval($_POST['apy'] ?? 0);

if ($pool_name==='' || $token_pair==='' || $coin1==='' || $coin2==='' || $amount1<=0 || $amount2<=0 || $apy<=0) {
    echo json_encode(['success'=>false,'message'=>'Geçerli bilgiler giriniz.']); exit;
}

try {
    $db = getDB();
    $db->beginTransaction();

    // Bakiye kontrolü ve dondurma
    foreach ([[$coin1,$amount1],[$coin2,$amount2]] as [$cs,$amt]) {
        $stmt = $db->prepare('SELECT available FROM wallets WHERE user_id=? AND coin_symbol=?');
        $stmt->execute([$user_id,$cs]);
        $w = $stmt->fetch();
        if (!$w || $w['available'] < $amt) { throw new Exception("Yetersiz bakiye: $cs"); }
        $stmt = $db->prepare('UPDATE wallets SET available=available-?, frozen=frozen+? WHERE user_id=? AND coin_symbol=?');
        $stmt->execute([$amt,$amt,$user_id,$cs]);
    }

    // Yield pozisyonu oluştur
    $stmt = $db->prepare('INSERT INTO yields (user_id,pool_name,token_pair,coin_symbol_1,coin_symbol_2,amount_1,amount_2,apy,rewards_1,rewards_2,status) VALUES (?,?,?,?,?,?,?,?,0,0,\'active\')');
    $stmt->execute([$user_id,$pool_name,$token_pair,$coin1,$coin2,$amount1,$amount2,$apy]);

    // İşlem logu
    $stmt = $db->prepare('INSERT INTO transactions (user_id,type,coin_symbol,amount,price,status,created_at) VALUES (?,?,?, ?,0,\'completed\',NOW())');
    $stmt->execute([$user_id,'yield_deposit',$coin1,-$amount1]);
    $stmt->execute([$user_id,'yield_deposit',$coin2,-$amount2]);

    $db->commit();
    echo json_encode(['success'=>true,'message'=>"Pozisyona katılım başarılı: {$pool_name}", 'yield_id'=>$db->lastInsertId()]);
} catch (Throwable $e) {
    if ($db && $db->inTransaction()) $db->rollBack();
    echo json_encode(['success'=>false,'message'=>'Hata: '.$e->getMessage()]);
}
