<?php
session_start();
header('Content-Type: application/json');
if (!isset($_SESSION['user_id'])) { echo json_encode(['success'=>false,'message'=>'Giriş yapın.']); exit; }
require_once __DIR__ . '/../config/database.php';

$user_id = $_SESSION['user_id'];
$yield_id = intval($_POST['yield_id'] ?? 0);
if ($yield_id <= 0) { echo json_encode(['success'=>false,'message'=>'Geçersiz ID']); exit; }

try {
    $db = getDB();
    $db->beginTransaction();

    $stmt = $db->prepare('SELECT * FROM yields WHERE id=? AND user_id=? AND status=\'active\' FOR UPDATE');
    $stmt->execute([$yield_id,$user_id]);
    $y = $stmt->fetch();
    if (!$y) throw new Exception('Pozisyon bulunamadı');

    $total1 = floatval($y['amount_1']) + floatval($y['rewards_1']);
    $total2 = floatval($y['amount_2']) + floatval($y['rewards_2']);

    // Frozen -> available, balance
    $stmt = $db->prepare('UPDATE wallets SET frozen=frozen-?, available=available+?, balance=balance+? WHERE user_id=? AND coin_symbol=?');
    $stmt->execute([$y['amount_1'],$total1,$total1,$user_id,$y['coin_symbol_1']]);
    $stmt->execute([$y['amount_2'],$total2,$total2,$user_id,$y['coin_symbol_2']]);

    $stmt = $db->prepare('UPDATE yields SET status=\'closed\' WHERE id=?');
    $stmt->execute([$yield_id]);

    $stmt = $db->prepare('INSERT INTO transactions (user_id,type,coin_symbol,amount,price,status,created_at) VALUES (\'$user_id\',\'yield_withdraw\',?,?,0,\'completed\',NOW())');
    $stmt->execute([$y['coin_symbol_1'],$total1]);
    $stmt->execute([$y['coin_symbol_2'],$total2]);

    $db->commit();
    echo json_encode(['success'=>true,'message'=>'Yield pozisyonu çekildi']);
} catch (Throwable $e) {
    if ($db && $db->inTransaction()) $db->rollBack();
    echo json_encode(['success'=>false,'message'=>'Hata: '.$e->getMessage()]);
}
