// Header Dropdown Menü JavaScript
document.addEventListener('DOMContentLoaded', function() {
    // Tüm dropdown trigger'ları bul
    const dropdownTriggers = document.querySelectorAll('[id*="trigger-user-"]');
    
    dropdownTriggers.forEach(trigger => {
        const dropdownId = trigger.getAttribute('aria-controls');
        const dropdownContent = document.getElementById(dropdownId);
        
        if (!dropdownContent) {
            // Dropdown content yoksa oluştur
            createDropdownContent(trigger, dropdownId);
        }
        
        // Hover event listeners ekle
        trigger.addEventListener('mouseenter', function(e) {
            // Diğer açık dropdown'ları kapat
            closeAllDropdowns();
            
            // Bu dropdown'ı aç
            openDropdown(trigger, dropdownContent);
        });
        
        // Dropdown'dan çıkınca kapat
        const dropdownContainer = trigger.closest('li');
        dropdownContainer.addEventListener('mouseleave', function(e) {
            closeDropdown(trigger, dropdownContent);
        });
    });
    
    // Dışarı tıklandığında dropdown'ları kapat
    document.addEventListener('click', function(e) {
        if (!e.target.closest('[id*="trigger-user-"]') && !e.target.closest('.dropdown-content')) {
            closeAllDropdowns();
        }
    });
    
    // ESC tuşu ile dropdown'ları kapat
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            closeAllDropdowns();
        }
    });
});

function createDropdownContent(trigger, dropdownId) {
    const triggerText = trigger.querySelector('span').textContent;
    const dropdownContent = document.createElement('div');
    dropdownContent.id = dropdownId;
    dropdownContent.className = 'dropdown-content absolute top-full left-0 mt-2 w-48 bg-white dark:bg-zinc-800 rounded-md shadow-lg border border-gray-200 dark:border-zinc-700 z-50 hidden';
    
    // Dropdown içeriği oluştur
    let menuItems = [];
    
    switch(triggerText) {
        case 'Trading':
            menuItems = [
                { text: 'Spot Trading', href: '/tr/trade' },
                { text: 'Futures', href: '/tr/futures' },
                { text: 'Options', href: '/tr/options' },
                { text: 'Margin Trading', href: '/tr/margin' }
            ];
            break;
        case 'Portfolio':
            menuItems = [
                { text: 'Overview', href: '/tr/portfolio' },
                { text: 'Holdings', href: '/tr/portfolio/holdings' },
                { text: 'Transactions', href: '/tr/portfolio/transactions' },
                { text: 'P&L', href: '/tr/portfolio/pnl' }
            ];
            break;
        case 'Investments':
            menuItems = [
                { text: 'Staking', href: '/tr/staking' },
                { text: 'Lending', href: '/tr/lending' },
                { text: 'Yield Farming', href: '/tr/yield' },
                { text: 'DeFi', href: '/tr/defi' }
            ];
            break;
        case 'Marketplace':
            menuItems = [
                { text: 'NFTs', href: '/tr/nft' },
                { text: 'Collectibles', href: '/tr/collectibles' },
                { text: 'Art', href: '/tr/art' },
                { text: 'Gaming', href: '/tr/gaming' }
            ];
            break;
        case 'Services':
            menuItems = [
                { text: 'API', href: '/tr/api' },
                { text: 'White Label', href: '/tr/whitelabel' },
                { text: 'Institutional', href: '/tr/institutional' },
                { text: 'Support', href: '/tr/support' }
            ];
            break;
    }
    
    // Menu items oluştur
    menuItems.forEach(item => {
        const menuItem = document.createElement('a');
        menuItem.href = item.href;
        menuItem.className = 'block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-zinc-700 hover:text-gray-900 dark:hover:text-white transition-colors duration-200';
        menuItem.textContent = item.text;
        dropdownContent.appendChild(menuItem);
    });
    
    // Dropdown'ı trigger'ın parent'ına ekle
    const parent = trigger.closest('li');
    parent.style.position = 'relative';
    parent.appendChild(dropdownContent);
}

function toggleDropdown(trigger, dropdownContent) {
    const isOpen = trigger.getAttribute('data-state') === 'open';
    
    if (isOpen) {
        closeDropdown(trigger, dropdownContent);
    } else {
        openDropdown(trigger, dropdownContent);
    }
}

function openDropdown(trigger, dropdownContent) {
    trigger.setAttribute('data-state', 'open');
    trigger.setAttribute('aria-expanded', 'true');
    
    // Dropdown'ı göster
    if (dropdownContent) {
        dropdownContent.classList.remove('hidden');
        dropdownContent.style.display = 'block';
    }
    
    // Chevron icon'u döndür
    const chevron = trigger.querySelector('.lucide-chevron-down');
    if (chevron) {
        chevron.style.transform = 'rotate(180deg)';
        chevron.classList.add('rotate-180');
    }
}

function closeDropdown(trigger, dropdownContent) {
    trigger.setAttribute('data-state', 'closed');
    trigger.setAttribute('aria-expanded', 'false');
    
    // Dropdown'ı gizle
    if (dropdownContent) {
        dropdownContent.classList.add('hidden');
        dropdownContent.style.display = 'none';
    }
    
    // Chevron icon'u normale döndür
    const chevron = trigger.querySelector('.lucide-chevron-down');
    if (chevron) {
        chevron.style.transform = 'rotate(0deg)';
        chevron.classList.remove('rotate-180');
    }
}

function closeAllDropdowns() {
    const allTriggers = document.querySelectorAll('[id*="trigger-user-"]');
    const allContents = document.querySelectorAll('.dropdown-content');
    
    allTriggers.forEach(trigger => {
        trigger.setAttribute('data-state', 'closed');
        trigger.setAttribute('aria-expanded', 'false');
        
        const chevron = trigger.querySelector('.lucide-chevron-down');
        if (chevron) {
            chevron.style.transform = 'rotate(0deg)';
            chevron.classList.remove('rotate-180');
        }
    });
    
    allContents.forEach(content => {
        content.classList.add('hidden');
        content.style.display = 'none';
    });
}
