<?php
session_start();
header('Content-Type: application/json');

if (isset($_SESSION['user_id']) && isset($_SESSION['user_name']) && isset($_SESSION['user_email'])) {
    // Veritabanından profil resmini çek
    require_once __DIR__ . '/../config/database.php';
    
    $user_avatar = null;
    try {
        $db = getDB();
        $stmt = $db->prepare("SELECT profile_image FROM users WHERE id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $user_data = $stmt->fetch();
        
        if ($user_data && !empty($user_data['profile_image'])) {
            $user_avatar = $user_data['profile_image'];
        }
    } catch (Exception $e) {
        // Hata durumunda null kalır
    }
    
    echo json_encode([
        'logged_in' => true,
        'user_id' => $_SESSION['user_id'],
        'user_name' => $_SESSION['user_name'],
        'user_email' => $_SESSION['user_email'],
        'user_avatar' => $user_avatar
    ]);
} else {
    echo json_encode([
        'logged_in' => false
    ]);
}
?>





