<?php
session_start();
require_once __DIR__ . '/../config/database.php';

// AJAX isteği kontrolü
$isAjax = isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    if ($isAjax) {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'error' => 'invalid_request']);
    } else {
        header('Location: ../login.php?error=invalid_request');
    }
    exit;
}

// Verileri al
$email = isset($_POST['email']) ? sanitize($_POST['email']) : '';
$password = isset($_POST['password']) ? $_POST['password'] : '';
$remember = isset($_POST['remember']) && $_POST['remember'] === 'on';

// Validasyon
if (empty($email)) {
    if ($isAjax) {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'error' => 'email_required']);
    } else {
        header('Location: ../login.php?error=email_required');
    }
    exit;
}

if (empty($password)) {
    if ($isAjax) {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'error' => 'password_required']);
    } else {
        header('Location: ../login.php?error=password_required');
    }
    exit;
}

try {
    $db = getDB();
    
    // Kullanıcıyı bul
    $stmt = $db->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();
    
    if (!$user) {
        if ($isAjax) {
            header('Content-Type: application/json');
            echo json_encode(['success' => false, 'error' => 'invalid_credentials']);
        } else {
            header('Location: ../login.php?error=invalid_credentials');
        }
        exit;
    }
    
    // Hesap durumu kontrolü
    if (isset($user['status']) && $user['status'] !== 'active') {
        if ($isAjax) {
            header('Content-Type: application/json');
            echo json_encode(['success' => false, 'error' => 'account_inactive']);
        } else {
            header('Location: ../login.php?error=account_inactive');
        }
        exit;
    }
    
    // Şifre kontrolü - hashlenmiş şifreyi doğrula
    if (!verifyPassword($password, $user['password'])) {
        if ($isAjax) {
            header('Content-Type: application/json');
            echo json_encode(['success' => false, 'error' => 'invalid_credentials']);
        } else {
            header('Location: ../login.php?error=invalid_credentials');
        }
        exit;
    }
    
    // Session oluştur
    $_SESSION['user_id'] = $user['id'];
    $_SESSION['user_name'] = $user['first_name'] . ' ' . $user['last_name'];
    $_SESSION['user_email'] = $user['email'];
    $_SESSION['user_status'] = $user['status'];
    
    // Remember me
    if ($remember) {
        $token = generateToken();
        setcookie('remember_token', $token, time() + (86400 * 30), '/'); // 30 gün
        
        // Token'ı veritabanına kaydet (isterseniz)
        // $stmt = $db->prepare("UPDATE users SET remember_token = ? WHERE id = ?");
        // $stmt->execute([$token, $user['id']]);
    }
    
    // Login time'ı güncelle
    $update_stmt = $db->prepare("UPDATE users SET updated_at = NOW() WHERE id = ?");
    $update_stmt->execute([$user['id']]);
    
    // Başarılı giriş
    // Base URL'i dinamik olarak oluştur
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    $script_dir = dirname(dirname($_SERVER['SCRIPT_NAME']));
    $base_url = $protocol . '://' . $host . $script_dir;
    $redirect_url = rtrim($base_url, '/') . '/index.php';
    
    if ($isAjax) {
        header('Content-Type: application/json');
        echo json_encode(['success' => true, 'redirect' => $redirect_url]);
    } else {
        header('Location: ' . $redirect_url);
    }
    exit;
    
} catch (PDOException $e) {
    if ($isAjax) {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'error' => 'database_error']);
    } else {
        header('Location: ../login.php?error=database_error');
    }
    exit;
}

?>

