<?php
session_start();
require_once __DIR__ . '/../config/database.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Geçersiz istek']);
    exit;
}

// Verileri al
$first_name = isset($_POST['first_name']) ? sanitize($_POST['first_name']) : '';
$last_name = isset($_POST['last_name']) ? sanitize($_POST['last_name']) : '';
$email = isset($_POST['email']) ? sanitize($_POST['email']) : '';
$password = isset($_POST['password']) ? $_POST['password'] : '';
$confirm_password = isset($_POST['confirm_password']) ? $_POST['confirm_password'] : '';

// Validasyon
$errors = [];

if (empty($first_name)) {
    $errors[] = 'Ad gereklidir';
}

if (empty($last_name)) {
    $errors[] = 'Soyad gereklidir';
}

if (empty($email)) {
    $errors[] = 'E-posta gereklidir';
} elseif (!isValidEmail($email)) {
    $errors[] = 'Geçerli bir e-posta adresi girin';
}

if (empty($password)) {
    $errors[] = 'Şifre gereklidir';
} elseif (strlen($password) < 8) {
    $errors[] = 'Şifre en az 8 karakter olmalıdır';
} elseif (!preg_match('/[A-Z]/', $password)) {
    $errors[] = 'Şifre en az bir büyük harf içermelidir';
} elseif (!preg_match('/[a-z]/', $password)) {
    $errors[] = 'Şifre en az bir küçük harf içermelidir';
} elseif (!preg_match('/[0-9]/', $password)) {
    $errors[] = 'Şifre en az bir rakam içermelidir';
} elseif (!preg_match('/[^A-Za-z0-9]/', $password)) {
    $errors[] = 'Şifre en az bir özel karakter içermelidir';
}

if ($password !== $confirm_password) {
    $errors[] = 'Şifreler eşleşmiyor';
}

// Hata varsa döndür
if (!empty($errors)) {
    echo json_encode(['success' => false, 'message' => implode(', ', $errors)]);
    exit;
}

try {
    $db = getDB();
    
    // E-posta kontrolü
    $stmt = $db->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->execute([$email]);
    
    if ($stmt->fetch()) {
        echo json_encode(['success' => false, 'message' => 'Bu e-posta adresi zaten kullanılıyor']);
        exit;
    }
    
    // Kullanıcı kaydı
    $hashed_password = hashPassword($password);
    
    $stmt = $db->prepare("
        INSERT INTO users (first_name, last_name, email, password) 
        VALUES (?, ?, ?, ?)
    ");
    
    $stmt->execute([$first_name, $last_name, $email, $hashed_password]);
    
    $user_id = $db->lastInsertId();
    
    // Başlangıç cüzdanları oluştur (sıfır bakiye ile)
    $initial_coins = ['USDT', 'BTC', 'ETH', 'SOL', 'BNB', 'TRY'];
    
    foreach ($initial_coins as $coin) {
        $stmt = $db->prepare("
            INSERT INTO wallets (user_id, coin_symbol, balance, available, frozen) 
            VALUES (?, ?, 0.00000000, 0.00000000, 0.00000000)
        ");
        $stmt->execute([$user_id, $coin]);
    }
    
    // Session oluştur
    $_SESSION['user_id'] = $user_id;
    $_SESSION['user_name'] = $first_name . ' ' . $last_name;
    $_SESSION['user_email'] = $email;
    
    echo json_encode([
        'success' => true, 
        'message' => 'Hesap başarıyla oluşturuldu!',
        'redirect' => 'index.php'
    ]);
    
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Kayıt sırasında bir hata oluştu: ' . $e->getMessage()]);
}

?>

