<?php
// Günlük portföy değerini kaydetmek için script
require_once 'config/database.php';

try {
    $db = getDB();
    
    // Tüm kullanıcıları al
    $stmt = $db->prepare("SELECT DISTINCT user_id FROM wallets");
    $stmt->execute();
    $users = $stmt->fetchAll();
    
    // Kripto fiyatlarını al
    $crypto_prices = [];
    if (file_exists('assets/crypto_prices.json')) {
        $price_data = json_decode(file_get_contents('assets/crypto_prices.json'), true);
        $crypto_prices = $price_data['prices'] ?? [];
    }
    
    foreach ($users as $user) {
        $user_id = $user['user_id'];
        
        // Kullanıcının cüzdanlarını al
        $stmt = $db->prepare("SELECT * FROM wallets WHERE user_id = ?");
        $stmt->execute([$user_id]);
        $wallets = $stmt->fetchAll();
        
        // Toplam portföy değerini hesapla
        $total_value = 0;
        foreach ($wallets as $wallet) {
            $price = $crypto_prices[$wallet['coin_symbol']]['raw_price'] ?? 1;
            $total_value += floatval($wallet['balance']) * floatval($price);
        }
        
        // Bugünkü değeri kaydet (duplicate key update ile)
        $stmt = $db->prepare("INSERT INTO portfolio_history (user_id, date, total_value) VALUES (?, CURDATE(), ?) ON DUPLICATE KEY UPDATE total_value = ?");
        $stmt->execute([$user_id, $total_value, $total_value]);
        
        echo "Kullanıcı $user_id için günlük portföy değeri kaydedildi: $" . number_format($total_value, 2) . "\n";
    }
    
    echo "Tüm kullanıcılar için günlük portföy değerleri kaydedildi!\n";
    
} catch (Exception $e) {
    echo "Hata: " . $e->getMessage() . "\n";
}
?>


