<?php
session_start();
require_once 'config/database.php';

try {
    $db = getDB();
    
    // User ID 2'nin TRY cüzdanını düzelt
    $stmt = $db->prepare("UPDATE wallets SET frozen = 0 WHERE user_id = 2 AND coin_symbol = 'TRY'");
    $result = $stmt->execute();
    
    echo "Frozen bakiye sıfırlandı: " . ($result ? 'SUCCESS' : 'FAILED') . "<br>";
    
    // Cüzdan durumunu kontrol et
    $stmt = $db->prepare("SELECT * FROM wallets WHERE user_id = 2 AND coin_symbol = 'TRY'");
    $stmt->execute();
    $wallet = $stmt->fetch();
    
    if ($wallet) {
        echo "<h3>Güncel Cüzdan Durumu:</h3>";
        echo "<strong>Balance:</strong> " . $wallet['balance'] . "<br>";
        echo "<strong>Available:</strong> " . $wallet['available'] . "<br>";
        echo "<strong>Frozen:</strong> " . $wallet['frozen'] . "<br>";
    }
    
    // Çekim talebini pending'e çevir (test için)
    $stmt = $db->prepare("UPDATE withdrawals SET status = 'pending' WHERE id = 1");
    $stmt->execute();
    
    echo "<br>Çekim talebi pending durumuna çevrildi.";
    
} catch (Exception $e) {
    echo "Hata: " . $e->getMessage();
}
?>
