<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

include 'components/header.php';
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vadeli İşlem - KriptoCum</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/style.css">
    <script src="assets/js/dropdown.js"></script>
</head>
<body class="bg-gray-50">
    <!-- Main Content -->
    <div class="pt-16 min-h-screen">
        <div class="container mx-auto px-4 py-8">
            <!-- Header -->
            <div class="mb-8">
                <h1 class="text-3xl font-bold text-gray-800 mb-2">Vadeli İşlem</h1>
                <p class="text-gray-600">Kaldıraçlı kripto para vadeli işlemleri</p>
            </div>

            <!-- Trading Interface -->
            <div class="grid grid-cols-12 gap-6">
                <!-- Left Sidebar - Markets -->
                <div class="col-span-12 lg:col-span-3">
                    <div class="bg-white rounded-lg shadow-sm border border-gray-200">
                        <div class="p-4 border-b border-gray-200">
                            <h3 class="text-lg font-semibold text-gray-800">Vadeli Piyasalar</h3>
                        </div>
                        <div class="overflow-y-auto max-h-[600px]">
                            <div id="futuresMarketsList" class="p-2 space-y-1">
                                <!-- Markets will be loaded here -->
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Main Trading Area -->
                <div class="col-span-12 lg:col-span-9">
                    <div class="grid grid-cols-12 gap-6">
                        <!-- Chart Area -->
                        <div class="col-span-12 lg:col-span-8">
                            <div class="bg-white rounded-lg shadow-sm border border-gray-200">
                                <div class="p-4 border-b border-gray-200">
                                    <div class="flex items-center justify-between">
                                        <div>
                                            <h3 class="text-xl font-bold text-gray-800" id="selectedPair">BTCUSDT</h3>
                                            <div class="text-sm text-gray-600" id="currentPrice">$43,250.50</div>
                                        </div>
                                        <div class="text-right">
                                            <div class="text-sm text-green-600 font-semibold" id="priceChange">+2.34%</div>
                                            <div class="text-xs text-gray-500">24s Değişim</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="p-4">
                                    <div id="futures_chart" style="height: 400px;">
                                        <!-- TradingView Chart will be loaded here -->
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Order Book & Recent Trades -->
                        <div class="col-span-12 lg:col-span-4">
                            <!-- Order Book -->
                            <div class="bg-white rounded-lg shadow-sm border border-gray-200 mb-4">
                                <div class="p-3 border-b border-gray-200">
                                    <div class="flex items-center justify-between">
                                        <div class="text-sm font-semibold text-gray-700">Emir Defteri</div>
                                        <div class="text-xs text-gray-500">Spread: <span class="font-semibold text-gray-700" id="spreadValue">0.00%</span></div>
                                    </div>
                                </div>
                                <div class="overflow-y-auto max-h-[200px]">
                                    <!-- Asks (Sell Orders) -->
                                    <div class="p-3 space-y-0.5">
                                        <div class="text-xs text-gray-500 mb-1 px-2">Satış</div>
                                        <div class="text-xs text-right space-y-0.5" id="asksList">
                                            <!-- Real data will be loaded -->
                                        </div>
                                    </div>
                                    
                                    <!-- Current Price -->
                                    <div class="p-3 bg-blue-50 border-y border-blue-200">
                                        <div class="text-center">
                                            <div class="text-xs text-gray-600">Fiyat</div>
                                            <div id="currentPriceDisplay" class="text-xl font-bold text-gray-800 mt-1">43,250.50</div>
                                            <div id="currentChangeDisplay" class="text-xs text-green-600 font-semibold">+2.34%</div>
                                        </div>
                                    </div>
                                    
                                    <!-- Bids (Buy Orders) -->
                                    <div class="p-3 space-y-0.5">
                                        <div class="text-xs text-gray-500 mb-1 px-2">Alış</div>
                                        <div class="text-xs space-y-0.5" id="bidsList">
                                            <!-- Real data will be loaded -->
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Recent Trades -->
                            <div class="bg-white rounded-lg shadow-sm border border-gray-200">
                                <div class="p-3 border-b border-gray-200">
                                    <div class="text-sm font-semibold text-gray-700">Son İşlemler</div>
                                </div>
                                <div class="overflow-y-auto max-h-[200px]">
                                    <div class="p-3 space-y-1" id="tradesList">
                                        <!-- Real data will be loaded -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Trading Form -->
                    <div class="mt-6">
                        <div class="bg-white rounded-lg shadow-sm border border-gray-200">
                            <div class="flex border-b border-gray-200">
                                <button onclick="setOrderType('buy')" id="buyBtn" class="flex-1 px-4 py-3 font-semibold text-white bg-green-600 hover:bg-green-700 transition-colors">
                                    LONG
                                </button>
                                <button onclick="setOrderType('sell')" id="sellBtn" class="flex-1 px-4 py-3 font-semibold text-gray-600 hover:bg-gray-50 transition-colors bg-gray-100">
                                    SHORT
                                </button>
                                <button class="px-3 py-3 text-gray-400 hover:text-gray-600 hover:bg-gray-50">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <circle cx="12" cy="12" r="10"></circle>
                                        <line x1="12" y1="16" x2="12" y2="12"></line>
                                        <line x1="12" y1="8" x2="12.01" y2="8"></line>
                                    </svg>
                                </button>
                            </div>
                            
                            <div class="p-4 space-y-4">
                                <!-- Leverage -->
                                <div>
                                    <div class="flex items-center justify-between mb-2">
                                        <label class="text-sm font-medium text-gray-700">Kaldıraç</label>
                                        <span class="text-xs text-gray-500" id="leverageDisplay">1x</span>
                                    </div>
                                    <div class="flex gap-2">
                                        <button onclick="setLeverage(1)" class="px-3 py-1 text-xs bg-gray-100 hover:bg-gray-200 rounded">1x</button>
                                        <button onclick="setLeverage(5)" class="px-3 py-1 text-xs bg-gray-100 hover:bg-gray-200 rounded">5x</button>
                                        <button onclick="setLeverage(10)" class="px-3 py-1 text-xs bg-gray-100 hover:bg-gray-200 rounded">10x</button>
                                        <button onclick="setLeverage(20)" class="px-3 py-1 text-xs bg-gray-100 hover:bg-gray-200 rounded">20x</button>
                                        <button onclick="setLeverage(50)" class="px-3 py-1 text-xs bg-gray-100 hover:bg-gray-200 rounded">50x</button>
                                    </div>
                                </div>

                                <!-- Entry Price -->
                                <div>
                                    <div class="flex items-center justify-between mb-2">
                                        <label class="text-sm font-medium text-gray-700">Giriş Fiyatı</label>
                                        <button onclick="setMarketPrice()" class="text-xs text-blue-600 hover:text-blue-700">Piyasa Fiyatı</button>
                                    </div>
                                    <input type="text" id="entryPriceInput" value="" oninput="calculatePosition()" class="w-full px-4 py-2 text-sm border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent">
                                </div>
                                
                                <!-- Position Size -->
                                <div>
                                    <div class="flex items-center justify-between mb-2">
                                        <label class="text-sm font-medium text-gray-700">Pozisyon Büyüklüğü</label>
                                        <div class="flex gap-1">
                                            <button onclick="setPercentage(25)" class="text-xs text-blue-600 hover:text-blue-700 px-1">%25</button>
                                            <button onclick="setPercentage(50)" class="text-xs text-blue-600 hover:text-blue-700 px-1">%50</button>
                                            <button onclick="setPercentage(75)" class="text-xs text-blue-600 hover:text-blue-700 px-1">%75</button>
                                            <button onclick="setPercentage(100)" class="text-xs text-blue-600 hover:text-blue-700 px-1">%100</button>
                                        </div>
                                    </div>
                                    <input type="text" id="positionSizeInput" placeholder="0.00" oninput="calculatePosition()" class="w-full px-4 py-2 text-sm border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent">
                                </div>
                                
                                <!-- Margin -->
                                <div class="relative">
                                    <input type="text" id="marginInput" placeholder="≈ $0.00" readonly class="w-full px-4 py-2 text-sm border-2 border-gray-200 rounded-lg bg-gray-50 text-gray-600">
                                    <span class="absolute right-3 top-2.5 text-xs text-gray-500">USDT</span>
                                </div>

                                <!-- Stop Loss & Take Profit -->
                                <div class="grid grid-cols-2 gap-4">
                                    <div>
                                        <label class="text-sm font-medium text-gray-700">Zarar Durdur</label>
                                        <input type="text" id="stopLossInput" placeholder="0.00" oninput="calculatePosition()" class="w-full px-3 py-2 text-sm border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                                    </div>
                                    <div>
                                        <label class="text-sm font-medium text-gray-700">Kar Al</label>
                                        <input type="text" id="takeProfitInput" placeholder="0.00" oninput="calculatePosition()" class="w-full px-3 py-2 text-sm border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent">
                                    </div>
                                </div>
                                
                                <!-- Buttons -->
                                <div class="flex gap-2 pt-2">
                                    <button id="orderBtn" onclick="placeFuturesOrder()" class="flex-1 bg-green-600 hover:bg-green-700 text-white py-3 rounded-lg font-semibold transition-colors">
                                        <span id="orderBtnText">LONG Pozisyon Aç</span>
                                    </button>
                                </div>
                                
                                <!-- Balance Info -->
                                <div class="pt-3 border-t border-gray-200">
                                    <div class="flex justify-between text-xs text-gray-600 mb-1">
                                        <span>Müsait Bakiye</span>
                                        <span class="font-semibold text-gray-800" id="availableBalance">0.00 USDT</span>
                                    </div>
                                    <div class="flex justify-between text-xs text-gray-600">
                                        <span>Kullanılan Margin</span>
                                        <span class="font-semibold text-gray-800" id="usedMargin">0.00 USDT</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- TradingView Widget -->
    <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
    <script>
        // Global state
        let currentSymbol = 'BTC';
        let currentOrderType = 'buy';
        let currentPrice = 0;
        let leverage = 1;
        let availableBalance = 1000; // Demo balance

        function setOrderType(type) {
            const buyBtn = document.getElementById('buyBtn');
            const sellBtn = document.getElementById('sellBtn');
            const orderBtn = document.getElementById('orderBtn');
            const orderBtnText = document.getElementById('orderBtnText');
            
            currentOrderType = type;
            
            if (type === 'buy') {
                buyBtn.classList.remove('bg-gray-100', 'text-gray-600');
                buyBtn.classList.add('bg-green-600', 'text-white');
                sellBtn.classList.remove('bg-red-600', 'text-white');
                sellBtn.classList.add('bg-gray-100', 'text-gray-600', 'hover:bg-gray-50');
                orderBtnText.textContent = `LONG Pozisyon Aç`;
                orderBtn.classList.remove('bg-red-600', 'hover:bg-red-700');
                orderBtn.classList.add('bg-green-600', 'hover:bg-green-700');
            } else {
                sellBtn.classList.remove('bg-gray-100', 'text-gray-600');
                sellBtn.classList.add('bg-red-600', 'text-white');
                buyBtn.classList.remove('bg-green-600', 'text-white');
                buyBtn.classList.add('bg-gray-100', 'text-gray-600', 'hover:bg-gray-50');
                orderBtnText.textContent = `SHORT Pozisyon Aç`;
                orderBtn.classList.remove('bg-green-600', 'hover:bg-green-700');
                orderBtn.classList.add('bg-red-600', 'hover:bg-red-700');
            }
        }

        function setLeverage(lev) {
            leverage = lev;
            document.getElementById('leverageDisplay').textContent = lev + 'x';
            calculatePosition();
        }

        function setMarketPrice() {
            document.getElementById('entryPriceInput').value = currentPrice.toFixed(8);
            calculatePosition();
        }

        function setPercentage(percent) {
            const balance = availableBalance;
            const price = parseFloat(document.getElementById('entryPriceInput').value) || currentPrice;
            const positionSize = (balance * percent / 100) / price;
            document.getElementById('positionSizeInput').value = positionSize.toFixed(8);
            calculatePosition();
        }

        function calculatePosition() {
            const entryPrice = parseFloat(document.getElementById('entryPriceInput').value.replace(/,/g, '')) || 0;
            const positionSize = parseFloat(document.getElementById('positionSizeInput').value.replace(/,/g, '')) || 0;
            const margin = (entryPrice * positionSize) / leverage;
            document.getElementById('marginInput').value = `≈ $${margin.toFixed(2)}`;
        }

        function placeFuturesOrder() {
            const entryPrice = parseFloat(document.getElementById('entryPriceInput').value.replace(/,/g, '')) || 0;
            const positionSize = parseFloat(document.getElementById('positionSizeInput').value.replace(/,/g, '')) || 0;
            const stopLoss = document.getElementById('stopLossInput').value;
            const takeProfit = document.getElementById('takeProfitInput').value;
            
            if (entryPrice <= 0 || positionSize <= 0) {
                alert('Giriş fiyatı ve pozisyon büyüklüğü gereklidir!');
                return;
            }
            
            const orderType = currentOrderType === 'buy' ? 'LONG' : 'SHORT';
            alert(`${orderType} pozisyonu açıldı: ${positionSize} ${currentSymbol} @ $${entryPrice.toFixed(8)} ${leverage}x kaldıraç ile`);
        }

        async function loadFuturesData(coinSymbol) {
            try {
                const symbol = `${coinSymbol}USDT`;
                const response = await fetch(`get_trading_data.php?symbol=${symbol}&type=all`);
                const data = await response.json();
                
                if (data.price) {
                    currentPrice = data.price.lastPrice;
                    document.getElementById('entryPriceInput').value = currentPrice.toFixed(8);
                    
                    // Update header
                    document.getElementById('selectedPair').textContent = `${coinSymbol}USDT`;
                    document.getElementById('currentPrice').textContent = `$${data.price.lastPrice.toFixed(2)}`;
                    
                    const changeColor = data.price.priceChangePercent >= 0 ? 'green' : 'red';
                    const sign = data.price.priceChangePercent >= 0 ? '+' : '';
                    document.getElementById('priceChange').className = `text-sm text-${changeColor}-600 font-semibold`;
                    document.getElementById('priceChange').textContent = `${sign}${data.price.priceChangePercent.toFixed(2)}%`;
                    
                    // Update current price display
                    document.getElementById('currentPriceDisplay').textContent = data.price.lastPrice.toFixed(2);
                    document.getElementById('currentChangeDisplay').className = `text-xs text-${changeColor}-600 font-semibold`;
                    document.getElementById('currentChangeDisplay').textContent = `${sign}${data.price.priceChangePercent.toFixed(2)}%`;
                }
                
                if (data.orderbook) {
                    updateOrderBook(data.orderbook);
                }
                
                if (data.trades) {
                    updateRecentTrades(data.trades);
                }
                
                calculatePosition();
            } catch (error) {
                console.error('Futures data could not be loaded:', error);
            }
        }
        
        function updateOrderBook(orderbook) {
            const asksList = document.getElementById('asksList');
            const bidsList = document.getElementById('bidsList');
            
            // Clear existing
            asksList.innerHTML = '';
            bidsList.innerHTML = '';
            
            // Update asks (sell orders - red)
            orderbook.asks.slice(0, 8).forEach(ask => {
                const price = parseFloat(ask[0]);
                const qty = parseFloat(ask[1]);
                const div = document.createElement('div');
                div.className = 'flex items-center justify-between px-2 py-0.5 hover:bg-red-50 cursor-pointer';
                div.innerHTML = `<span class="text-gray-600">${price.toFixed(8)}</span><span class="text-red-600 font-semibold">${qty.toFixed(4)}</span>`;
                div.onclick = () => document.getElementById('entryPriceInput').value = price;
                asksList.appendChild(div);
            });
            
            // Update bids (buy orders - green)
            orderbook.bids.slice(0, 8).forEach(bid => {
                const price = parseFloat(bid[0]);
                const qty = parseFloat(bid[1]);
                const div = document.createElement('div');
                div.className = 'flex items-center justify-between px-2 py-0.5 hover:bg-green-50 cursor-pointer';
                div.innerHTML = `<span class="text-green-600 font-semibold">${qty.toFixed(4)}</span><span class="text-gray-600">${price.toFixed(8)}</span>`;
                div.onclick = () => document.getElementById('entryPriceInput').value = price;
                bidsList.appendChild(div);
            });
            
            // Calculate spread
            if (orderbook.asks.length > 0 && orderbook.bids.length > 0) {
                const bestAsk = parseFloat(orderbook.asks[0][0]);
                const bestBid = parseFloat(orderbook.bids[0][0]);
                const spread = ((bestAsk - bestBid) / bestAsk) * 100;
                document.getElementById('spreadValue').textContent = spread.toFixed(4) + '%';
            }
        }
        
        function updateRecentTrades(trades) {
            const tradesList = document.getElementById('tradesList');
            tradesList.innerHTML = '';
            
            trades.slice(0, 10).forEach(trade => {
                const price = trade.price;
                const qty = trade.qty;
                const time = new Date(trade.time);
                const isBuy = !trade.isBuyer;
                const color = isBuy ? 'text-green-600' : 'text-red-600';
                const timeStr = time.toLocaleTimeString('tr-TR', { hour: '2-digit', minute: '2-digit', second: '2-digit' });
                
                const div = document.createElement('div');
                div.className = 'flex items-center justify-between text-xs';
                div.innerHTML = `<span class="${color}">${price.toFixed(8)}</span><span class="text-gray-600">${qty.toFixed(4)}</span><span class="text-gray-400">${timeStr}</span>`;
                tradesList.appendChild(div);
            });
        }

        async function loadFuturesMarkets() {
            try {
                const response = await fetch('assets/crypto_prices.json?t=' + Date.now());
                const data = await response.json();
                
                if (data && data.prices) {
                    const marketsList = document.getElementById('futuresMarketsList');
                    marketsList.innerHTML = '';
                    
                    // Dış kaynak görsel fallback'lerini kullanma; yalnızca mevcut (yerel) görsel varsa göster
                    
                    let first = true;
                    for (const [symbol, priceData] of Object.entries(data.prices)) {
                        const changeColor = parseFloat(priceData.raw_change) >= 0 ? 'green' : 'red';
                        const changeSign = parseFloat(priceData.raw_change) >= 0 ? '+' : '';
                        const isActive = first ? 'border-l-4 border-blue-600 bg-blue-50/50' : 'hover:bg-gray-50';
                        const hasImage = priceData.image && priceData.image.trim() !== '';
                        const badge = `<div class=\"w-5 h-5 rounded-full bg-gray-200 text-gray-700 text-[10px] font-bold flex items-center justify-center\">${symbol.substring(0,2)}</div>`;
                        const logoHtml = hasImage ? `<img src=\"${priceData.image}\" alt=\"${symbol}\" class=\"w-5 h-5 object-contain\">` : badge;
                        
                        marketsList.innerHTML += `
                            <div class="p-2 rounded cursor-pointer ${isActive}" data-coin="${symbol}" data-symbol="BINANCE:${symbol}USDT">
                                <div class="flex items-center gap-2 mb-1">
                                     <div class=\"w-6 h-6 rounded-full overflow-hidden bg-gray-100 flex items-center justify-center\">${logoHtml}</div>
                                    <span class="text-sm font-semibold">${symbol}</span>
                                    <span class="text-xs text-${changeColor}-600 font-semibold ml-auto">${changeSign}${priceData.change}%</span>
                                </div>
                                <div class="flex items-center justify-between text-xs">
                                    <span class="text-gray-500">$${priceData.price}</span>
                                    <span class="text-gray-400">Vol: ${priceData.volume}</span>
                                </div>
                            </div>
                        `;

                        first = false;
                    }
                    
                    // Add click events to dynamically loaded elements
                    document.querySelectorAll('[data-coin]').forEach(pair => {
                        pair.addEventListener('click', function() {
                            const symbol = this.getAttribute('data-symbol');
                            selectFuturesPair(symbol);
                            
                            // Remove active class from all
                            document.querySelectorAll('[data-coin]').forEach(el => {
                                el.classList.remove('border-l-4', 'border-blue-600', 'bg-blue-50/50');
                                el.classList.add('hover:bg-gray-50');
                            });
                            
                            // Add active class to clicked element
                            this.classList.add('border-l-4', 'border-blue-600', 'bg-blue-50/50');
                            this.classList.remove('hover:bg-gray-50');

                        });
                    });
                }
            } catch (error) {
                console.error('Futures markets could not be loaded:', error);
            }
        }

        function selectFuturesPair(symbol) {
            console.log('Futures pair selected:', symbol);
            
            // Destroy existing widget and create new one
            if (window.tvWidget) {
                try {
                    if (window.tvWidget.setSymbol) {
                        window.tvWidget.setSymbol(symbol, '1D');
                        console.log('Chart updated:', symbol);
                    } else {
                        console.log('setSymbol method not available, recreating widget...');
                        window.tvWidget.remove();
                        
                        window.tvWidget = new TradingView.widget({
                            "autosize": true,
                            "symbol": symbol,
                            "interval": "1D",
                            "timezone": "Europe/Istanbul",
                            "theme": "light",
                            "style": "1",
                            "locale": "tr",
                            "toolbar_bg": "#f1f3f6",
                            "enable_publishing": false,
                            "hide_top_toolbar": false,
                            "hide_legend": false,
                            "save_image": false,
                            "container_id": "futures_chart",
                            "studies": ["RSI@tv-basicstudies", "MACD@tv-basicstudies"],
                            "show_popup_button": true,
                            "popup_width": "1000",
                            "popup_height": "650",
                            "no_referral_id": true,
                            "referral_id": "kriptocum"
                        });
                        console.log('New widget created:', symbol);
                    }
                } catch (e) {
                    console.error('Chart could not be updated:', e);
                }
            }
            
            // Extract coin symbol from BINANCE:BTCUSDT format
            const coinSymbol = symbol.split(':')[1].replace('USDT', '');
            currentSymbol = coinSymbol;
            
            // Load futures data
            loadFuturesData(coinSymbol);
            
            // Update button text
            const orderBtnText = document.getElementById('orderBtnText');
            if (orderBtnText) {
                orderBtnText.textContent = `${currentOrderType === 'buy' ? 'Open LONG Position' : 'Open SHORT Position'}`;
            }
        }

        function startFuturesDataUpdates(coinSymbol) {
            setInterval(() => {
                loadFuturesData(coinSymbol);
            }, 5000); // Update every 5 seconds
        }

        document.addEventListener('DOMContentLoaded', function() {
            loadFuturesMarkets(); // Initial load
            
            // Initialize TradingView widget
            setTimeout(() => {
                window.tvWidget = new TradingView.widget({
                    "autosize": true,
                    "symbol": "BINANCE:BTCUSDT",
                    "interval": "1D",
                    "timezone": "Europe/Istanbul",
                    "theme": "light",
                    "style": "1",
                    "locale": "tr",
                    "toolbar_bg": "#f1f3f6",
                    "enable_publishing": false,
                    "hide_top_toolbar": false,
                    "hide_legend": false,
                    "save_image": false,
                    "container_id": "futures_chart",
                    "studies": ["RSI@tv-basicstudies", "MACD@tv-basicstudies"],
                    "show_popup_button": true,
                    "popup_width": "1000",
                    "popup_height": "650",
                    "no_referral_id": true,
                    "referral_id": "kriptocum"
                });
            }, 1000);
            
            // Load initial BTC data
            setTimeout(() => {
                loadFuturesData('BTC');
                currentSymbol = 'BTC';
                
                // Balance display
                document.getElementById('availableBalance').textContent = availableBalance.toFixed(2) + ' USDT';
                document.getElementById('usedMargin').textContent = '0.00 USDT';
            }, 2000);
            
            // Start automatic updates
            setTimeout(() => {
                startFuturesDataUpdates('BTC');
            }, 3000);
        });
    </script>

    <?php include 'components/footer.php'; ?>
</body>
</html>


