<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Giriş yapmanız gerekiyor.']);
    exit;
}

require_once 'config/database.php';

$user_id = $_SESSION['user_id'];

try {
    $db = getDB();
    
    // Kullanıcının cüzdanlarını al
    $stmt = $db->prepare("SELECT * FROM wallets WHERE user_id = ?");
    $stmt->execute([$user_id]);
    $wallets = $stmt->fetchAll();
    
    // Kripto fiyatlarını al
    $crypto_prices = [];
    if (file_exists('assets/crypto_prices.json')) {
        $price_data = json_decode(file_get_contents('assets/crypto_prices.json'), true);
        $crypto_prices = $price_data['prices'] ?? [];
    }
    
    // Gerçek portföy performans verilerini veritabanından al
    $portfolio_performance = [];
    
    // Period parametresini al (7d, 30d, 90d)
    $period = $_GET['period'] ?? '7d';
    $days = $period === '7d' ? 7 : ($period === '30d' ? 30 : 90);
    
    // Son N günlük gerçek verileri al
    $stmt = $db->prepare("SELECT date, total_value FROM portfolio_history WHERE user_id = ? AND date >= DATE_SUB(CURDATE(), INTERVAL ? DAY) ORDER BY date ASC");
    $stmt->execute([$user_id, $days]);
    $history_data = $stmt->fetchAll();
    
    // Eğer geçmiş veri yoksa, bugünkü değeri hesapla ve kaydet
    if (empty($history_data)) {
        $base_value = 0;
        foreach ($wallets as $wallet) {
            $price = $crypto_prices[$wallet['coin_symbol']]['raw_price'] ?? 1;
            $base_value += floatval($wallet['balance']) * floatval($price);
        }
        
        // Bugünkü değeri kaydet
        $stmt = $db->prepare("INSERT INTO portfolio_history (user_id, date, total_value) VALUES (?, CURDATE(), ?) ON DUPLICATE KEY UPDATE total_value = ?");
        $stmt->execute([$user_id, $base_value, $base_value]);
        
        $portfolio_performance[] = [
            'date' => date('Y-m-d'),
            'value' => round($base_value, 2)
        ];
    } else {
        // Gerçek geçmiş verileri kullan
        foreach ($history_data as $row) {
            $portfolio_performance[] = [
                'date' => $row['date'],
                'value' => round($row['total_value'], 2)
            ];
        }
    }
    
    // Toplam portföy değerini hesapla (güncel)
    $base_value = 0;
    foreach ($wallets as $wallet) {
        $price = $crypto_prices[$wallet['coin_symbol']]['raw_price'] ?? 1;
        $base_value += floatval($wallet['balance']) * floatval($price);
    }
    
    // Piyasa verilerini hazırla
    $market_data = [];
    $top_coins = ['BTC', 'ETH', 'SOL', 'XRP', 'ADA', 'DOT', 'MATIC', 'AVAX'];
    
    foreach ($top_coins as $coin) {
        if (isset($crypto_prices[$coin])) {
            $market_data[] = [
                'symbol' => $coin,
                'price' => $crypto_prices[$coin]['raw_price'],
                'change' => $crypto_prices[$coin]['raw_change'],
                'volume' => $crypto_prices[$coin]['volume'] ?? 'N/A'
            ];
        }
    }
    
    echo json_encode([
        'success' => true,
        'data' => [
            'wallets' => $wallets,
            'crypto_prices' => $crypto_prices,
            'portfolio_performance' => $portfolio_performance,
            'market_data' => $market_data,
            'total_balance' => $base_value
        ]
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Veritabanı hatası: ' . $e->getMessage()
    ]);
}
?>
