<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Piyasalar - Kriptocum</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="assets/style.css">
    <script src="assets/js/dropdown.js"></script>
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
</head>
<body class="bg-gray-50">
    <?php include 'components/header.php'; ?>
    
    <main class="pt-16">
        <div class="container mx-auto px-4 py-8">
            <!-- Markets Header -->
            <div class="mb-8">
                <h1 class="text-3xl font-bold text-gray-800 mb-2">Piyasalar</h1>
                <p class="text-gray-600">Gerçek zamanlı kripto para fiyatları</p>
            </div>
            
            <!-- Market Stats - TradingView Style -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-8">
                <!-- BTC Card -->
                <div class="bg-white rounded-lg border border-gray-200 shadow-sm hover:shadow-md transition-shadow cursor-pointer" onclick="window.location.href='trade.php'">
                    <div class="p-4">
                        <div class="flex items-center justify-between mb-3">
                            <div class="flex items-center gap-2">
                                <div class="w-8 h-8 rounded-full overflow-hidden bg-gray-100 flex items-center justify-center">
                                    <div id="btcLogo" class="w-6 h-6 rounded-full bg-gray-200 text-gray-700 text-[10px] font-bold flex items-center justify-center">BT</div>
                                </div>
                                <div>
                                    <div class="text-sm font-semibold text-gray-800">BTC/USDT</div>
                                    <div class="text-xs text-gray-500">Bitcoin</div>
                                </div>
                            </div>
                            <div class="text-right">
                                <div class="text-lg font-bold text-gray-800" id="btcPrice">$0</div>
                                <div class="text-sm font-semibold" id="btcChange">+0%</div>
                            </div>
                        </div>
                        <div class="h-16 bg-gray-50 rounded-lg flex items-center justify-center">
                            <div class="text-xs text-gray-500">Fiyat Grafiği</div>
                        </div>
                    </div>
                </div>

                <!-- ETH Card -->
                <div class="bg-white rounded-lg border border-gray-200 shadow-sm hover:shadow-md transition-shadow cursor-pointer" onclick="window.location.href='trade.php'">
                    <div class="p-4">
                        <div class="flex items-center justify-between mb-3">
                            <div class="flex items-center gap-2">
                                <div class="w-8 h-8 rounded-full overflow-hidden bg-gray-100 flex items-center justify-center">
                                    <div id="ethLogo" class="w-6 h-6 rounded-full bg-gray-200 text-gray-700 text-[10px] font-bold flex items-center justify-center">ET</div>
                                </div>
                                <div>
                                    <div class="text-sm font-semibold text-gray-800">ETH/USDT</div>
                                    <div class="text-xs text-gray-500">Ethereum</div>
                                </div>
                            </div>
                            <div class="text-right">
                                <div class="text-lg font-bold text-gray-800" id="ethPrice">$0</div>
                                <div class="text-sm font-semibold" id="ethChange">+0%</div>
                            </div>
                        </div>
                        <div class="h-16 bg-gray-50 rounded-lg flex items-center justify-center">
                            <div class="text-xs text-gray-500">Fiyat Grafiği</div>
                        </div>
                    </div>
                </div>

                <!-- SOL Card -->
                <div class="bg-white rounded-lg border border-gray-200 shadow-sm hover:shadow-md transition-shadow cursor-pointer" onclick="window.location.href='trade.php'">
                    <div class="p-4">
                        <div class="flex items-center justify-between mb-3">
                            <div class="flex items-center gap-2">
                                <div class="w-8 h-8 rounded-full overflow-hidden bg-gray-100 flex items-center justify-center">
                                    <div id="solLogo" class="w-6 h-6 rounded-full bg-gray-200 text-gray-700 text-[10px] font-bold flex items-center justify-center">SO</div>
                                </div>
                                <div>
                                    <div class="text-sm font-semibold text-gray-800">SOL/USDT</div>
                                    <div class="text-xs text-gray-500">Solana</div>
                                </div>
                            </div>
                            <div class="text-right">
                                <div class="text-lg font-bold text-gray-800" id="solPrice">$0</div>
                                <div class="text-sm font-semibold" id="solChange">+0%</div>
                            </div>
                        </div>
                        <div class="h-16 bg-gray-50 rounded-lg flex items-center justify-center">
                            <div class="text-xs text-gray-500">Fiyat Grafiği</div>
                        </div>
                    </div>
                </div>

                <!-- Market Overview Card -->
                <div class="bg-white rounded-lg border border-gray-200 shadow-sm">
                    <div class="p-4">
                        <div class="text-center">
                            <div class="text-sm font-semibold text-gray-600 mb-2">Piyasa Genel Bakış</div>
                            <div class="space-y-2">
                                <div class="flex justify-between items-center">
                                    <span class="text-xs text-gray-500">24s Hacim</span>
                                    <span class="text-sm font-semibold text-gray-800" id="totalVolume">$0B</span>
                                </div>
                                <div class="flex justify-between items-center">
                                    <span class="text-xs text-gray-500">Aktif Çiftler</span>
                                    <span class="text-sm font-semibold text-gray-800" id="activePairs">0</span>
                                </div>
                                <div class="flex justify-between items-center">
                                    <span class="text-xs text-gray-500">Piyasa Değeri</span>
                                    <span class="text-sm font-semibold text-gray-800" id="marketCap">$0T</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Markets Table -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                <div class="p-6 border-b border-gray-200">
                    <div class="flex items-center justify-between">
                        <h2 class="text-xl font-bold text-gray-800">Tüm Piyasalar</h2>
                        <input type="text" placeholder="🔍 Ara..." class="px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" id="searchInput">
                    </div>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full" id="marketsTable">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase cursor-pointer hover:bg-gray-100" onclick="sortTable('symbol')">
                                    Çift <span id="sortSymbol">▼</span>
                                </th>
                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-600 uppercase cursor-pointer hover:bg-gray-100" onclick="sortTable('price')">
                                    Fiyat <span id="sortPrice">▼</span>
                                </th>
                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-600 uppercase cursor-pointer hover:bg-gray-100" onclick="sortTable('change')">
                                    24s Değişim <span id="sortChange">▼</span>
                                </th>
                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-600 uppercase cursor-pointer hover:bg-gray-100" onclick="sortTable('volume')">
                                    Hacim <span id="sortVolume">▼</span>
                                </th>
                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-600 uppercase">İşlem</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200" id="marketsBody">
                            <!-- Veriler yüklenecek -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </main>
    
    <script>
        let marketsData = [];
        let currentSort = { column: null, order: 'desc' };
        
        async function loadMarkets() {
            try {
                const response = await fetch('assets/crypto_prices.json?t=' + Date.now());
                const data = await response.json();
                
                if (data && data.prices) {
                    marketsData = Object.entries(data.prices).map(([symbol, priceData]) => ({
                        symbol,
                        price: parseFloat(priceData.raw_price),
                        change: parseFloat(priceData.raw_change),
                        volume: priceData.volume,
                        formatted_price: priceData.price,
                        formatted_change: priceData.change,
                        image: priceData.image || ''
                    }));
                    
                    updateMarketsTable();
                    updateTopStats();
                }
            } catch (error) {
                console.error('Markets yüklenemedi:', error);
            }
        }
        
        function updateMarketsTable() {
            const tbody = document.getElementById('marketsBody');
            tbody.innerHTML = '';
            
                marketsData.forEach(market => {
                const changeColor = market.change >= 0 ? 'text-green-600' : 'text-red-600';
                const bgColor = market.change >= 0 ? 'bg-green-50' : 'bg-red-50';
                const sign = market.change >= 0 ? '+' : '';
                
                // Logo: yalnızca mevcut image varsa göster, yoksa rozet
                const hasImage = market.image && market.image.trim() !== '';
                
                const tr = document.createElement('tr');
                tr.className = 'hover:bg-gray-50 cursor-pointer';
                tr.onclick = () => window.location.href = `trade.php`;
                tr.innerHTML = `
                    <td class="px-6 py-4">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 rounded-full overflow-hidden bg-gray-100 flex items-center justify-center">
                                ${hasImage ? `<img src="${market.image}" alt="${market.symbol}" class="w-8 h-8 object-contain">` : `<div class=\"w-8 h-8 rounded-full bg-gray-200 text-gray-700 text-[11px] font-bold flex items-center justify-center\">${market.symbol.substring(0,2)}</div>`}
                            </div>
                            <div>
                                <div class="font-semibold text-gray-800">${market.symbol}</div>
                                <div class="text-xs text-gray-500">${market.symbol}</div>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4 text-right font-mono text-gray-800 font-semibold">$${market.formatted_price}</td>
                    <td class="px-6 py-4 text-right">
                        <span class="px-2 py-1 rounded text-sm font-semibold ${changeColor} ${bgColor}">
                            ${sign}${market.formatted_change}%
                        </span>
                    </td>
                    <td class="px-6 py-4 text-right text-gray-600">${market.volume}</td>
                    <td class="px-6 py-4 text-right">
                        <a href="trade.php" class="text-blue-600 hover:text-blue-700 text-sm font-medium">Trade</a>
                    </td>
                `;
                tbody.appendChild(tr);
            });
        }
        
        function updateTopStats() {
            const btc = marketsData.find(m => m.symbol === 'BTC');
            const eth = marketsData.find(m => m.symbol === 'ETH');
            const sol = marketsData.find(m => m.symbol === 'SOL');
            
            // Update BTC card
            if (btc) {
                document.getElementById('btcPrice').textContent = btc.formatted_price;
                const btcChange = document.getElementById('btcChange');
                btcChange.textContent = btc.change >= 0 ? `+${btc.formatted_change}%` : `${btc.formatted_change}%`;
                btcChange.className = `text-sm font-semibold ${btc.change >= 0 ? 'text-green-600' : 'text-red-600'}`;
                if (btc.image && btc.image.trim() !== '') {
                    const el = document.getElementById('btcLogo');
                    if (el) el.src = btc.image;
                }
            }
            
            // Update ETH card
            if (eth) {
                document.getElementById('ethPrice').textContent = eth.formatted_price;
                const ethChange = document.getElementById('ethChange');
                ethChange.textContent = eth.change >= 0 ? `+${eth.formatted_change}%` : `${eth.formatted_change}%`;
                ethChange.className = `text-sm font-semibold ${eth.change >= 0 ? 'text-green-600' : 'text-red-600'}`;
                if (eth.image && eth.image.trim() !== '') {
                    const el = document.getElementById('ethLogo');
                    if (el) el.src = eth.image;
                }
            }
            
            // Update SOL card
            if (sol) {
                document.getElementById('solPrice').textContent = sol.formatted_price;
                const solChange = document.getElementById('solChange');
                solChange.textContent = sol.change >= 0 ? `+${sol.formatted_change}%` : `${sol.formatted_change}%`;
                solChange.className = `text-sm font-semibold ${sol.change >= 0 ? 'text-green-600' : 'text-red-600'}`;
                if (sol.image && sol.image.trim() !== '') {
                    const el = document.getElementById('solLogo');
                    if (el) el.src = sol.image;
                }
            }

            // Update Market Overview
            updateMarketOverview();
        }

        function updateMarketOverview() {
            // Calculate total volume (simplified)
            let totalVolume = 0;
            let activePairs = marketsData.length;
            let totalMarketCap = 0;

            marketsData.forEach(market => {
                const volume = parseFloat(market.volume.replace(/[,$]/g, ''));
                const price = market.price;
                
                if (!isNaN(volume)) totalVolume += volume;
                if (!isNaN(price)) totalMarketCap += price * 1000000; // Simplified market cap
            });

            // Format and display
            document.getElementById('totalVolume').textContent = formatNumber(totalVolume) + 'B';
            document.getElementById('activePairs').textContent = activePairs.toString();
            document.getElementById('marketCap').textContent = formatNumber(totalMarketCap / 1000000000) + 'T';
        }

        function formatNumber(num) {
            if (num >= 1000000000) {
                return (num / 1000000000).toFixed(1);
            } else if (num >= 1000000) {
                return (num / 1000000).toFixed(1);
            } else if (num >= 1000) {
                return (num / 1000).toFixed(1);
            }
            return num.toFixed(1);
        }
        
        function sortTable(column) {
            if (currentSort.column === column) {
                currentSort.order = currentSort.order === 'asc' ? 'desc' : 'asc';
            } else {
                currentSort.column = column;
                currentSort.order = 'desc';
            }
            
            marketsData.sort((a, b) => {
                if (currentSort.order === 'asc') {
                    return a[column] > b[column] ? 1 : -1;
                } else {
                    return a[column] < b[column] ? 1 : -1;
                }
            });
            
            updateMarketsTable();
        }
        
        document.getElementById('searchInput').addEventListener('input', function(e) {
            const searchTerm = e.target.value.toLowerCase();
            // Filter functionality here
        });
        
        document.addEventListener('DOMContentLoaded', function() {
            loadMarkets();
            setInterval(loadMarkets, 30000); // Her 30 saniyede bir güncelle
        });
    </script>
</body>
</html>

