<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kayıt Ol - Kriptocum</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="assets/style.css">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
</head>
<body class="bg-background text-foreground">
    <!-- Register Modal -->
    <div id="registerModal" class="fixed inset-0 z-50">
        <!-- Modal Overlay -->
        <div class="fixed inset-0 bg-black/50 backdrop-blur-sm" onclick="closeRegisterModal()"></div>
        
        <!-- Register Modal Content -->
        <div role="dialog" id="register-modal-content" aria-describedby="register-description" aria-labelledby="register-title" 
             data-state="open" data-slot="dialog-content" 
             class="bg-background data-[state=open]:animate-in data-[state=closed]:animate-out data-[state=closed]:fade-out-0 data-[state=open]:fade-in-0 data-[state=closed]:zoom-out-95 data-[state=open]:zoom-in-95 fixed top-[50%] left-[50%] z-50 grid max-w-[calc(100%-2rem)] translate-x-[-50%] translate-y-[-50%] gap-4 border duration-200 sm:max-w-xl p-0 border-none shadow-2xl rounded-xl w-[95vw] sm:w-full max-h-[90vh] overflow-hidden bg-gradient-to-b from-background to-background/95 backdrop-blur-sm" 
             tabindex="-1" style="pointer-events: auto;">
            
            <h2 id="register-title" data-slot="dialog-title" class="text-lg leading-none font-semibold">
                <span class="sr-only">Kimlik Doğrulama</span>
            </h2>
            
            <p id="register-description" data-slot="dialog-description" class="text-muted-foreground text-sm">
                <span class="sr-only">Güvenli bir şekilde giriş yapın veya hesap oluşturun.</span>
            </p>
            
            <!-- Background Effects -->
            <div class="absolute inset-0 overflow-hidden pointer-events-none">
                <div class="absolute -top-24 -left-24 w-64 h-64 bg-primary/10 rounded-full blur-3xl"></div>
                <div class="absolute -bottom-24 -right-24 w-64 h-64 bg-primary/10 rounded-full blur-3xl"></div>
            </div>
            
            <!-- Modal Content -->
            <div class="max-h-[90vh] pb-8 overflow-y-auto scrollbar-hide auth-modal-content opacity-100">
                <div class="p-8">
                    <div class="space-y-6">
                        <!-- Header -->
                        <div class="space-y-2 text-center">
                            <h2 class="text-3xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-primary to-primary/70">Hesap oluştur</h2>
                            <p class="text-muted-foreground">Hesabınızı oluşturmak için bilgilerinizi girin</p>
                        </div>
                        
                        <!-- Register Form -->
                        <form id="register-form-page" class="space-y-5" action="auth/register.php" method="POST">
                            <!-- Name Fields -->
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                                <div class="relative transition-all duration-300 form-field-animate rounded-lg ring-1 ring-input">
                                    <div class="flex-1 w-full flex flex-col">
                                        <div class="border-input placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground h-9 w-full min-w-0 rounded-md px-3 transition-[color,box-shadow] outline-hidden disabled:pointer-events-none disabled:cursor-not-allowed disabled:opacity-50 md:text-sm aria-invalid:ring-destructive/20 aria-invalid:border-destructive flex items-center focus-visible:border-ring focus-visible:ring-ring/50 shadow-sm border-0 pl-10 py-6 bg-transparent focus-visible:ring-0 focus-visible:ring-offset-0 text-base">
                                            <input data-slot="input" class="flex-1 bg-transparent border-none p-0 m-0 focus:outline-none focus:ring-0" 
                                                   placeholder="Ad" required="" type="text" name="first_name" value="">
                                        </div>
                                    </div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-user absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 transition-colors text-muted-foreground">
                                        <path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path>
                                        <circle cx="12" cy="7" r="4"></circle>
                                    </svg>
                                </div>
                                <div class="relative transition-all duration-300 form-field-animate rounded-lg ring-1 ring-input">
                                    <div class="flex-1 w-full flex flex-col">
                                        <div class="border-input placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground h-9 w-full min-w-0 rounded-md px-3 transition-[color,box-shadow] outline-hidden disabled:pointer-events-none disabled:cursor-not-allowed disabled:opacity-50 md:text-sm aria-invalid:ring-destructive/20 aria-invalid:border-destructive flex items-center focus-visible:border-ring focus-visible:ring-ring/50 shadow-sm border-0 pl-10 py-6 bg-transparent focus-visible:ring-0 focus-visible:ring-offset-0 text-base">
                                            <input data-slot="input" class="flex-1 bg-transparent border-none p-0 m-0 focus:outline-none focus:ring-0" 
                                                   placeholder="Soyad" required="" type="text" name="last_name" value="">
                                        </div>
                                    </div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-user absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 transition-colors text-muted-foreground">
                                        <path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path>
                                        <circle cx="12" cy="7" r="4"></circle>
                                    </svg>
                                </div>
                            </div>
                            
                            <!-- Email Field -->
                            <div class="space-y-2">
                                <div class="relative transition-all duration-300 form-field-animate rounded-lg ring-1 ring-input">
                                    <div class="flex-1 w-full flex flex-col">
                                        <div class="border-input placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground h-9 w-full min-w-0 rounded-md px-3 transition-[color,box-shadow] outline-hidden disabled:pointer-events-none disabled:cursor-not-allowed disabled:opacity-50 md:text-sm aria-invalid:ring-destructive/20 aria-invalid:border-destructive flex items-center focus-visible:border-ring focus-visible:ring-ring/50 shadow-sm border-0 pl-10 py-6 bg-transparent focus-visible:ring-0 focus-visible:ring-offset-0 text-base">
                                            <input data-slot="input" class="flex-1 bg-transparent border-none p-0 m-0 focus:outline-none focus:ring-0" 
                                                   placeholder="E-posta" required="" type="email" name="email" value="">
                                        </div>
                                    </div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-mail absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 transition-colors text-muted-foreground">
                                        <rect width="20" height="16" x="2" y="4" rx="2"></rect>
                                        <path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"></path>
                                    </svg>
                                </div>
                            </div>
                            
                            <!-- Password Field -->
                            <div class="space-y-2">
                                <div class="relative transition-all duration-300 form-field-animate rounded-lg ring-1 ring-input">
                                    <div class="flex-1 w-full flex flex-col">
                                        <div class="border-input placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground h-9 w-full min-w-0 rounded-md px-3 text-base transition-[color,box-shadow] outline-hidden disabled:pointer-events-none disabled:cursor-not-allowed disabled:opacity-50 md:text-sm aria-invalid:ring-destructive/20 aria-invalid:border-destructive flex items-center focus-visible:border-ring focus-visible:ring-ring/50 shadow-sm border-0 pl-10 pr-10 py-6 bg-transparent focus-visible:ring-0 focus-visible:ring-offset-0">
                                            <input data-slot="input" class="flex-1 bg-transparent border-none p-0 m-0 focus:outline-none focus:ring-0" 
                                                   placeholder="Şifre" required="" type="password" name="password" value="" id="register-password">
                                        </div>
                                    </div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-lock absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 transition-colors text-muted-foreground">
                                        <rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect>
                                        <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                                    </svg>
                                    <button type="button" onclick="toggleRegisterPassword()" class="absolute right-3 top-1/2 -translate-y-1/2 h-5 w-5 text-muted-foreground hover:text-primary transition-colors" tabindex="-1">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-eye" id="register-eye-icon">
                                            <path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"></path>
                                            <circle cx="12" cy="12" r="3"></circle>
                                        </svg>
                                    </button>
                                </div>
                                <div class="space-y-2 mt-2">
                                    <div class="text-xs text-muted-foreground bg-muted/50 p-3 rounded-lg">
                                        <div class="flex items-center mb-1">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-info h-3 w-3 mr-1">
                                                <circle cx="12" cy="12" r="10"></circle>
                                                <path d="M12 16v-4"></path>
                                                <path d="M12 8h.01"></path>
                                            </svg>
                                            <span class="font-medium">Şifre şunları içermelidir:</span>
                                        </div>
                                        <ul class="list-disc list-inside space-y-0.5 ml-4 text-xs">
                                            <li>En az 8 karakter</li>
                                            <li>Bir büyük harf</li>
                                            <li>Bir küçük harf</li>
                                            <li>Bir rakam</li>
                                            <li>Bir özel karakter</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Confirm Password Field -->
                            <div class="space-y-2">
                                <div class="relative transition-all duration-300 form-field-animate rounded-lg ring-1 ring-input">
                                    <div class="flex-1 w-full flex flex-col">
                                        <div class="border-input placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground h-9 w-full min-w-0 rounded-md px-3 text-base transition-[color,box-shadow] outline-hidden disabled:pointer-events-none disabled:cursor-not-allowed disabled:opacity-50 md:text-sm aria-invalid:ring-destructive/20 aria-invalid:border-destructive flex items-center focus-visible:border-ring focus-visible:ring-ring/50 shadow-sm border-0 pl-10 pr-10 py-6 bg-transparent focus-visible:ring-0 focus-visible:ring-offset-0">
                                            <input data-slot="input" class="flex-1 bg-transparent border-none p-0 m-0 focus:outline-none focus:ring-0" 
                                                   placeholder="Şifre Onayla" required="" type="password" name="confirm_password" value="" id="register-confirm-password">
                                        </div>
                                    </div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-lock absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 transition-colors text-muted-foreground">
                                        <rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect>
                                        <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                                    </svg>
                                    <button type="button" onclick="toggleRegisterConfirmPassword()" class="absolute right-3 top-1/2 -translate-y-1/2 h-5 w-5 text-muted-foreground hover:text-primary transition-colors" tabindex="-1">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-eye" id="register-confirm-eye-icon">
                                            <path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"></path>
                                            <circle cx="12" cy="12" r="3"></circle>
                                        </svg>
                                    </button>
                                </div>
                            </div>
                            
                            <!-- Submit Button -->
                            <button data-slot="button" class="inline-flex cursor-pointer items-center justify-center gap-2 whitespace-nowrap rounded-md font-medium disabled:pointer-events-none [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-hidden focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 aria-invalid:border-destructive bg-primary text-primary-foreground shadow-2xs hover:bg-primary/90 h-10 px-4 w-full py-6 text-base relative overflow-hidden btn-glow transition-all duration-300 bg-gradient-to-r from-primary to-primary/90 hover:from-primary/90 hover:to-primary disabled:opacity-50 disabled:cursor-not-allowed" type="submit">
                                <span class="flex items-center justify-center">
                                    Hesap oluştur
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-right ml-2 h-4 w-4">
                                        <path d="M5 12h14"></path>
                                        <path d="m12 5 7 7-7 7"></path>
                                    </svg>
                                </span>
                            </button>
                        </form>
                        
                        <!-- Trust Indicators -->
                        <div class="text-center text-xs text-muted-foreground">
                            <p>Dünya çapında 10.000+ kullanıcıya katılın</p>
                            <div class="flex justify-center mt-2 space-x-1">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                    <circle cx="12" cy="12" r="10"></circle>
                                    <path d="m9 12 2 2 4-4"></path>
                                </svg>
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                    <circle cx="12" cy="12" r="10"></circle>
                                    <path d="m9 12 2 2 4-4"></path>
                                </svg>
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                    <circle cx="12" cy="12" r="10"></circle>
                                    <path d="m9 12 2 2 4-4"></path>
                                </svg>
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                    <circle cx="12" cy="12" r="10"></circle>
                                    <path d="m9 12 2 2 4-4"></path>
                                </svg>
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                    <circle cx="12" cy="12" r="10"></circle>
                                    <path d="m9 12 2 2 4-4"></path>
                                </svg>
                            </div>
                        </div>
                        
                        <!-- Sign In Link -->
                        <div class="text-center">
                            <p class="text-sm text-muted-foreground">Zaten bir hesabınız var mı? 
                                <a href="login.php" class="inline-flex cursor-pointer items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm transition-[color,box-shadow] disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-hidden focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 aria-invalid:border-destructive text-primary underline-offset-4 hover:underline p-0 h-auto font-semibold">Oturum Aç</a>
                            </p>
                        </div>
                    </div>
                </div>
                
                <!-- Security Features -->
                <div class="px-8 pb-8 pt-2">
                    <div class="flex flex-col items-center justify-center space-y-3 text-center">
                        <div class="flex items-center justify-center space-x-2 text-xs text-muted-foreground">
                            <div class="flex items-center justify-center w-8 h-8 rounded-full bg-primary/10">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-lock h-4 w-4 text-primary">
                                    <rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect>
                                    <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                                </svg>
                            </div>
                            <span>Güvenli kimlik doğrulama</span>
                            <div class="w-px h-4 bg-border"></div>
                            <div class="flex items-center justify-center w-8 h-8 rounded-full bg-primary/10">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-shield h-4 w-4 text-primary">
                                    <path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"></path>
                                </svg>
                            </div>
                            <span>Veri koruma</span>
                            <div class="w-px h-4 bg-border"></div>
                            <div class="flex items-center justify-center w-8 h-8 rounded-full bg-primary/10">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-4 w-4 text-primary">
                                    <circle cx="12" cy="12" r="10"></circle>
                                    <path d="m9 12 2 2 4-4"></path>
                                </svg>
                            </div>
                            <span>Doğrulanmış güvenlik</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Close Button -->
            <button type="button" onclick="closeRegisterModal()" 
                    class="ring-offset-background focus:ring-ring data-[state=open]:bg-accent data-[state=open]:text-muted-foreground absolute top-4 right-4 rounded-xs opacity-70 transition-opacity hover:opacity-100 focus:ring-2 focus:ring-offset-2 focus:outline-hidden disabled:pointer-events-none [&_svg]:pointer-events-none [&_svg]:shrink-0 [&_svg:not([class*='size-'])]:size-4">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x">
                    <path d="M18 6 6 18"></path>
                    <path d="m6 6 12 12"></path>
                </svg>
                <span class="sr-only">Close</span>
            </button>
        </div>
    </div>

    <script>
    // Register Modal Functions
    function closeRegisterModal() {
        window.location.href = 'index.php';
    }

    // Register password toggle functionality
    function toggleRegisterPassword() {
        const passwordInput = document.getElementById('register-password');
        const eyeIcon = document.getElementById('register-eye-icon');
        
        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            eyeIcon.innerHTML = '<path d="M9.88 9.88a3 3 0 1 0 4.24 4.24"></path><path d="M10.73 5.08A10.43 10.43 0 0 1 12 5c7 0 10 7 10 7a13.16 13.16 0 0 1-1.67 2.68"></path><path d="M6.61 6.61A13.526 13.526 0 0 0 2 12s3 7 10 7a9.74 9.74 0 0 0 5.39-1.61"></path><line x1="2" x2="22" y1="2" y2="22"></line>';
        } else {
            passwordInput.type = 'password';
            eyeIcon.innerHTML = '<path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"></path><circle cx="12" cy="12" r="3"></circle>';
        }
    }

    // Register confirm password toggle functionality
    function toggleRegisterConfirmPassword() {
        const passwordInput = document.getElementById('register-confirm-password');
        const eyeIcon = document.getElementById('register-confirm-eye-icon');
        
        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            eyeIcon.innerHTML = '<path d="M9.88 9.88a3 3 0 1 0 4.24 4.24"></path><path d="M10.73 5.08A10.43 10.43 0 0 1 12 5c7 0 10 7 10 7a13.16 13.16 0 0 1-1.67 2.68"></path><path d="M6.61 6.61A13.526 13.526 0 0 0 2 12s3 7 10 7a9.74 9.74 0 0 0 5.39-1.61"></path><line x1="2" x2="22" y1="2" y2="22"></line>';
        } else {
            passwordInput.type = 'password';
            eyeIcon.innerHTML = '<path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"></path><circle cx="12" cy="12" r="3"></circle>';
        }
    }

    // Close modal on escape key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            closeRegisterModal();
        }
    });

    // Register form AJAX submission
    document.addEventListener('DOMContentLoaded', function() {
        const registerForm = document.getElementById('register-form-page');
        if (registerForm) {
            registerForm.addEventListener('submit', function(e) {
                e.preventDefault();
                
                const formData = new FormData(registerForm);
                const submitButton = registerForm.querySelector('button[type="submit"]');
                const originalText = submitButton.innerHTML;
                
                // Loading state
                submitButton.disabled = true;
                submitButton.innerHTML = '<span>İşleniyor...</span>';
                
                fetch('auth/register.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Başarı mesajı
                        alert(data.message || 'Hesap başarıyla oluşturuldu!');
                        
                        // Yönlendir
                        if (data.redirect) {
                            window.location.href = data.redirect;
                        } else {
                            window.location.href = 'index.php';
                        }
                    } else {
                        // Hata mesajı
                        alert(data.message || 'Kayıt sırasında bir hata oluştu.');
                        submitButton.disabled = false;
                        submitButton.innerHTML = originalText;
                    }
                })
                .catch(error => {
                    console.error('Register error:', error);
                    alert('Bir hata oluştu. Lütfen tekrar deneyin.');
                    submitButton.disabled = false;
                    submitButton.innerHTML = originalText;
                });
            });
        }
    });
    </script>
</body>
</html>


