<?php
require_once __DIR__ . '/../config/database.php';

try {
    $db = getDB();
    
    // Legal pages tablosu oluştur
    $db->exec("CREATE TABLE IF NOT EXISTS legal_pages (
        id INT AUTO_INCREMENT PRIMARY KEY,
        slug VARCHAR(100) NOT NULL UNIQUE,
        title VARCHAR(255) NOT NULL,
        content TEXT NOT NULL,
        is_active TINYINT(1) DEFAULT 1,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX idx_slug (slug),
        INDEX idx_is_active (is_active)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci");
    
    // Varsayılan içerikleri ekle
    $pages = [
        [
            'slug' => 'help',
            'title' => 'Yardım Merkezi',
            'content' => '<h1>Yardım Merkezi</h1><p>KriptoCum platformunu kullanırken karşılaştığınız soruların cevaplarını burada bulabilirsiniz.</p><h2>Nasıl başlarım?</h2><p>Hesabınızı oluşturun, e-postanızı doğrulayın ve ilk işleminizi yapmaya başlayın.</p><h2>Para nasıl yatırılır?</h2><p>Cüzdan sayfasından para yatırma seçeneğini seçerek kripto veya banka transferi ile para yatırabilirsiniz.</p>'
        ],
        [
            'slug' => 'contact',
            'title' => 'İletişim',
            'content' => '<h1>İletişim</h1><p>Bize ulaşmak için aşağıdaki kanalları kullanabilirsiniz.</p><h2>E-posta</h2><p>destek@kriptocum.com</p><h2>Telefon</h2><p>+90 212 XXX XX XX</p><h2>Adres</h2><p>İstanbul, Türkiye</p><h2>Çalışma Saatleri</h2><p>Pazartesi - Cuma: 09:00 - 18:00</p>'
        ],
        [
            'slug' => 'faq',
            'title' => 'Sık Sorulan Sorular',
            'content' => '<h1>Sık Sorulan Sorular</h1><h2>Hesap oluşturma</h2><p><strong>Soru:</strong> Nasıl hesap oluşturabilirim?<br><strong>Cevap:</strong> Ana sayfadaki "Kayıt Ol" butonuna tıklayarak hesabınızı oluşturabilirsiniz.</p><h2>Para yatırma</h2><p><strong>Soru:</strong> Para yatırma işlemi ne kadar sürer?<br><strong>Cevap:</strong> Kripto para yatırma işlemleri genellikle 10-30 dakika içinde onaylanır. Banka transferi 1-3 iş günü sürebilir.</p><h2>Para çekme</h2><p><strong>Soru:</strong> Para çekme limiti var mı?<br><strong>Cevap:</strong> Günlük çekim limiti 50.000 TL\'dir. Daha yüksek limitler için KYC doğrulaması gerekebilir.</p>'
        ],
        [
            'slug' => 'privacy',
            'title' => 'Gizlilik Politikası',
            'content' => '<h1>Gizlilik Politikası</h1><p>Son güncellenme: ' . date('d.m.Y') . '</p><h2>1. Veri Toplama</h2><p>KriptoCum olarak, hizmetlerimizi sunabilmek için bazı kişisel bilgilerinizi topluyoruz. Bu bilgiler şunları içerir:</p><ul><li>Ad ve soyad</li><li>E-posta adresi</li><li>Telefon numarası</li><li>Kimlik doğrulama bilgileri</li></ul><h2>2. Veri Kullanımı</h2><p>Topladığımız veriler sadece platform hizmetlerini sunmak, güvenliği sağlamak ve yasal yükümlülükleri yerine getirmek için kullanılır.</p><h2>3. Veri Paylaşımı</h2><p>Kişisel bilgileriniz üçüncü taraflarla paylaşılmaz, ancak yasal zorunluluklar gereği yetkili kurumlarla paylaşılabilir.</p><h2>4. Güvenlik</h2><p>Tüm verileriniz şifreli olarak saklanır ve en yüksek güvenlik standartları uygulanır.</p>'
        ],
        [
            'slug' => 'terms',
            'title' => 'Hizmet Şartları',
            'content' => '<h1>Hizmet Şartları</h1><p>Son güncellenme: ' . date('d.m.Y') . '</p><h2>1. Hizmetler</h2><p>KriptoCum, kripto para alım-satım ve diğer finansal hizmetleri sunar. Platformumuzu kullanarak bu şartları kabul etmiş sayılırsınız.</p><h2>2. Kullanıcı Sorumlulukları</h2><p>Kullanıcılar hesap bilgilerini güvende tutmakla sorumludur. Şifre paylaşılmamalı ve güvenli bir şekilde saklanmalıdır.</p><h2>3. İşlem Kuralları</h2><p>Tüm işlemler platform kurallarına uygun olarak yapılmalıdır. Yasadışı işlemler yasaktır.</p><h2>4. Limitler ve Kısıtlamalar</h2><p>Platform, işlem limitleri ve kuralları uygulama hakkını saklı tutar. Bu limitler güvenlik ve yasal uyumluluk için konulmuştur.</p><h2>5. Değişiklikler</h2><p>Bu şartlar önceden haber vermeksizin değiştirilebilir. Değişiklikler platformda yayınlandığı tarihten itibaren geçerlidir.</p>'
        ]
    ];
    
    foreach ($pages as $page) {
        $stmt = $db->prepare("INSERT INTO legal_pages (slug, title, content) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE title = VALUES(title), content = VALUES(content)");
        $stmt->execute([$page['slug'], $page['title'], $page['content']]);
    }
    
    echo "Legal pages tablosu başarıyla oluşturuldu ve varsayılan içerikler eklendi!\n";
    
} catch (Exception $e) {
    die("Hata: " . $e->getMessage());
}

