<?php
require_once __DIR__ . '/../config/database.php';

try {
    $db = getDB();

    $sql = "
    CREATE TABLE IF NOT EXISTS lendings (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        coin_symbol VARCHAR(10) NOT NULL,
        amount DECIMAL(18,8) NOT NULL,
        interest_rate DECIMAL(6,3) NOT NULL,
        interest_earned DECIMAL(18,8) NOT NULL DEFAULT 0,
        status ENUM('active','closed') NOT NULL DEFAULT 'active',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        INDEX idx_user (user_id),
        INDEX idx_status (status)
    );
    ";

    $db->exec($sql);
    echo "lendings tablosu oluşturuldu.\n";

} catch (Throwable $e) {
    echo "Hata: " . $e->getMessage() . "\n";
}
