<?php
require_once 'config/database.php';

try {
    $db = getDB();
    
    // stakes tablosunu oluştur
    $sql = "
    CREATE TABLE IF NOT EXISTS stakes (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        coin_symbol VARCHAR(10) NOT NULL,
        amount DECIMAL(18, 8) NOT NULL,
        apy DECIMAL(5, 2) NOT NULL,
        lock_period INT NOT NULL,
        rewards DECIMAL(18, 8) DEFAULT 0,
        status ENUM('active', 'locked', 'unlocked', 'completed') DEFAULT 'active',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        unlock_date TIMESTAMP NULL,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        INDEX idx_user_id (user_id),
        INDEX idx_status (status)
    );
    ";
    
    $db->exec($sql);
    echo "stakes tablosu başarıyla oluşturuldu.\n";
    
} catch (PDOException $e) {
    echo "Veritabanı hatası: " . $e->getMessage() . "\n";
} catch (Exception $e) {
    echo "Genel hata: " . $e->getMessage() . "\n";
}
?>
