<?php
require_once 'config/database.php';

try {
    $db = getDB();
    
    // withdrawals tablosunu oluştur
    $sql = "
    CREATE TABLE IF NOT EXISTS withdrawals (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        coin_symbol VARCHAR(10) NOT NULL,
        amount DECIMAL(18, 8) NOT NULL,
        bank_account_id INT,
        iban VARCHAR(34) NOT NULL,
        account_holder VARCHAR(255) NOT NULL,
        description TEXT,
        status ENUM('pending', 'approved', 'rejected', 'completed') DEFAULT 'pending',
        admin_notes TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        FOREIGN KEY (bank_account_id) REFERENCES bank_accounts(id) ON DELETE SET NULL
    );
    ";
    
    $db->exec($sql);
    echo "withdrawals tablosu başarıyla oluşturuldu.\n";
    
} catch (PDOException $e) {
    echo "Veritabanı hatası: " . $e->getMessage() . "\n";
} catch (Exception $e) {
    echo "Genel hata: " . $e->getMessage() . "\n";
}
?>
