<?php
require_once __DIR__ . '/../config/database.php';

try {
    $db = getDB();

    $sql = "
    CREATE TABLE IF NOT EXISTS yields (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        pool_name VARCHAR(100) NOT NULL,
        token_pair VARCHAR(50) NOT NULL,
        coin_symbol_1 VARCHAR(10) NOT NULL,
        coin_symbol_2 VARCHAR(10) NOT NULL,
        amount_1 DECIMAL(18,8) NOT NULL DEFAULT 0,
        amount_2 DECIMAL(18,8) NOT NULL DEFAULT 0,
        apy DECIMAL(6,3) NOT NULL,
        rewards_1 DECIMAL(18,8) NOT NULL DEFAULT 0,
        rewards_2 DECIMAL(18,8) NOT NULL DEFAULT 0,
        status ENUM('active','closed') NOT NULL DEFAULT 'active',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        INDEX idx_user (user_id),
        INDEX idx_status (status)
    );
    ";

    $db->exec($sql);
    echo "yields tablosu oluşturuldu.\n";

} catch (Throwable $e) {
    echo "Hata: " . $e->getMessage() . "\n";
}
