<?php
session_start();
require_once 'config/database.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Oturum açmanız gerekiyor']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Geçersiz istek']);
    exit;
}

if (!isset($_FILES['profile_image'])) {
    echo json_encode(['success' => false, 'message' => 'Dosya seçilmedi']);
    exit;
}

$file = $_FILES['profile_image'];
$user_id = $_SESSION['user_id'];

// Dosya validasyonu
$allowed_types = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
if (!in_array($file['type'], $allowed_types)) {
    echo json_encode(['success' => false, 'message' => 'Sadece resim dosyaları kabul edilir (JPEG, PNG, GIF, WebP)']);
    exit;
}

// Dosya boyutu kontrolü (5MB)
if ($file['size'] > 5 * 1024 * 1024) {
    echo json_encode(['success' => false, 'message' => 'Dosya boyutu 5MB\'dan küçük olmalıdır']);
    exit;
}

// Uploads klasörünü oluştur
$upload_dir = 'assets/uploads/profiles/';
if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0755, true);
}

// Dosya adını oluştur
$file_extension = pathinfo($file['name'], PATHINFO_EXTENSION);
$new_filename = 'profile_' . $user_id . '_' . time() . '.' . $file_extension;
$upload_path = $upload_dir . $new_filename;

// Dosyayı yükle
if (move_uploaded_file($file['tmp_name'], $upload_path)) {
    // Veritabanında profil resmi yolunu güncelle
    try {
        $db = getDB();
        $stmt = $db->prepare("UPDATE users SET profile_image = ? WHERE id = ?");
        $stmt->execute([$upload_path, $user_id]);
        
        echo json_encode([
            'success' => true, 
            'message' => 'Profil fotoğrafı başarıyla yüklendi',
            'image_path' => $upload_path
        ]);
    } catch (Exception $e) {
        // Dosyayı sil
        unlink($upload_path);
        echo json_encode(['success' => false, 'message' => 'Veritabanı hatası: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Dosya yüklenirken hata oluştu']);
}
?>





